(in-package "ACL2")

(include-book "rtl")

(include-book "ground-zero")

#|(defun decode (x n)
  (if (< x n) (ash 1 x) 0))
(in-theory (disable decode))
|#

(local (include-book "fl2"))
(local (include-book "ash"))
(local (include-book "bvecp"))

(defun decode (x n)
  (if (and (natp x) (< x n)) 
      (ash 1 x) 
    0))
(in-theory (disable decode))

(defthm decode-nonnegative-integer-type
  (and (integerp (decode x n))
       (<= 0 (decode x n)))
  :hints (("Goal" :in-theory (enable decode))))

;this rule is no better than decode-nonnegative-integer-type and might be worse:
(in-theory (disable (:type-prescription decode)))

(defthm decode-natp
  (natp (decode x n)))

(defthm bvecp-decode
  (implies (and (<= n m)
                (case-split (integerp m))
                )
           (bvecp (decode x n) m))
  :hints (("Goal" :in-theory (enable decode))))
