/*
 * acon a utility to facilitate the right to left writing
 * Copyright 1999 Ahmed Abdel-Hamid Mohamed <ahmedam@mail.usa.com>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 * Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <linux/kd.h>
#include <string.h>
#include <ctype.h>
#include "acon.h"
#include "child.h"
#include "arabicfont.h"
#include "render.h"

void get_ids(void);

int main(int argc,char **argv)
{
	int i,tty,useunicode=0;
	char *fontf=0,*translationf=0,*keymapf=0;

	get_ids();
	set_user_id();

	/*Read configure file if no input options*/
	if(argc<2)
	{
		char *env;
		FILE *fp;
		char font[300],translation[300],keymap[300];
		char tmp[300];

		font[0]=translation[0]=keymap[0]=0;
		if((env=getenv("HOME")))
			sprintf(tmp,"%s/.acon.conf",env);
		else
			strcpy(tmp,"/etc/acon.conf");
		if((fp=fopen(tmp,"r"))==NULL)
		{
			if((fp=fopen("/etc/acon.conf","r"))==NULL)
				goto noconfig;
		}

		while(!feof(fp))
		{
			char *s;
			fgets(tmp,300,fp);
			s=tmp;
			if(strchr(s,'\n'))*strchr(s,'\n')=0;

		/*Ignore comments*/
			if(strchr(s,'#'))*strchr(s,'#')=0;
			while(*s && isspace(*s))s++;
			/*If line is empty read another*/
			if(!s[0])continue;

			if(!strncmp(s,"add_console",11))
			{
				s+=11;
				while(*s && isspace(*s))s++;
				/*If line is empty read another*/
				if(!s[0])continue;
				sscanf(s,"%d",&i);
				addconsole(i);
				setconsole(i,font,keymap,translation,direction,usehendinums,useunicode);
			}
			else if(!strncmp(s,"hendinums",9))
			{
				s+=9;
				while(*s && isspace(*s))s++;
				/*If line is empty read another*/
				if(!s[0])continue;

				if(!strncmp(s,"always",6))
					usehendinums=1;
				else if(!strncmp(s,"context",7))
					usehendinums=2;
				else if(!strncmp(s,"never",5))
					usehendinums=0;
				else
					printf("Error in config file:unknow hendinums mod '%s'\n",s);
			}
			else if(!strncmp(s,"unicode",7))
			{
				s+=7;
				while(*s && isspace(*s))s++;
				/*If line is empty read another*/
				if(!s[0])continue;

				if(!strncmp(s,"enable",6))
					useunicode=1;
				else if(!strncmp(s,"disable",7))
					useunicode=0;
				else
					printf("Error in config file:unknow unicode mod '%s'\n",s);
			}
			else if(!strncmp(s,"direction",9))
			{
				s+=9;
				while(*s && isspace(*s))s++;
				/*If line is empty read another*/
				if(!s[0])continue;

				if(!strncmp(s,"RTL",3))
					direction=1;
				else if(!strncmp(s,"LTR",3))
					direction=0;
				else
					printf("Error in config file:unknown direction %s \n",s);
			}
			else if(!strncmp(s,"font",4))
			{
				s+=4;
				while(*s && isspace(*s))s++;
				font[0]=0;
				/*If line is empty read another*/
				if(!s[0])continue;
				i=strlen(s)-1;
				while(s[i] && isspace(s[i]) && i>0)i--;
				s[i+1]=0;
				strcpy(font,s);
			}
			else if(!strncmp(s,"keymap",6))
			{
				s+=6;
				while(*s && isspace(*s))s++;
				keymap[0]=0;
				/*If line is empty read another*/
				if(!s[0])continue;
				i=strlen(s)-1;
				while(s[i] && isspace(s[i]) && i>0)i--;
				s[i+1]=0;
				strcpy(keymap,s);
			}
			else if(!strncmp(s,"translation",11))
			{
				s+=11;
				while(*s && isspace(*s))s++;
				translation[0]=0;
				/*If line is empty read another*/
				if(!s[0])continue;
				i=strlen(s)-1;
				while(s[i] && isspace(s[i]) && i>0)i--;
				s[i+1]=0;
				strcpy(translation,s);
			}
			else
				printf("Syntax error in config file '%s'\n",tmp);
		}			
		fclose(fp);
	}
noconfig:
	for(i=1;i<argc;i++)
	{
		if(!strcmp(argv[i],"-?") || !strcmp(argv[i],"--help"))
		{
			printf("Acon version 1.0.5 By Ahmed Abdel-Hamid  (ahmedam@mail.usa.com)\n");
			printf("It transforms Linux console into an arabic console\n");
			printf("\nsyntax: %s [-?] [options] \n options:\n",argv[0]);
			printf("\t-s con1 .. \tspecify the consoles to process\n");
			printf("\t-ha\t\talways hendi numbers\n");
			printf("\t-hc\t\thendi numbers by context\n");
			printf("\t-hn\t\tnever hendi numbers\n");
			printf("\t-ue\t\tenable UTF-8\n");
			printf("\t-ud\t\tdisable UTF-8\n");
			printf("\t-dl\t\tconsole direction LTR\n");
			printf("\t-dr\t\tconsole direction RTL\n");
			printf("\t-f font\t\tload font as font file\n");
			printf("\t-t translation\tload translation as the font translation file\n");
			printf("\t-k keymap\tload keymap as key mapping file\n");
			printf("\nAll options can be used more than once\n");
			printf("\nHot keys:\n\tCTRL-ALT-TAB          : Change the direction of the console.\n"
					"\tCTRL-ALT-A            : Change the language of writing(Arabic<->English)\n"
					"\tCTRL-right/left shift : Change the direction of the console.\n"
					"\tCTRL-ALT-O            : Open the options menu.\n"
					"\tALT-right/left shift  : Change the language of writing.\n");
			printf("\n\nPlease send errors and suggestions to ahmedam@mail.usa.com\n");
			printf("Home page:   http://members.tripod.com/ahmedahamid/\n");
			return 0;
		}
		if(!strcmp(argv[i],"-s"))
		{
			while(i+1<argc && atoi(argv[i+1])>0)
			{
				addconsole(atoi(argv[++i]));
				setconsole(atoi(argv[i]),fontf,keymapf,translationf,direction,usehendinums,useunicode);
			}
			continue;
		}
		if(!strcmp(argv[i],"-ha"))
		{
			usehendinums=1;
		}
		if(!strcmp(argv[i],"-hc"))
		{
			usehendinums=2;
		}
		if(!strcmp(argv[i],"-hn"))
		{
			usehendinums=0;
		}
		if(!strcmp(argv[i],"-ue"))
		{
			useunicode=1;
		}
		if(!strcmp(argv[i],"-ud"))
		{
			useunicode=0;
		}
		if(!strcmp(argv[i],"-dl"))
		{
			direction=0;
		}
		if(!strcmp(argv[i],"-dr"))
		{
			direction=1;
		}
		if(!strcmp(argv[i],"-f"))
		{
			fontf=argv[++i];
			continue;
		}
		if(!strcmp(argv[i],"-m"))
		{
			translationf=argv[++i];
			continue;
		}
		if(!strcmp(argv[i],"-k"))
		{
			keymapf=argv[++i];
			continue;
		}
		
	}	

	if(getactive()==-1){
		fprintf(stderr,"Acon can run only in linux console\n");
		return 1;
	}
	
	if(consolesn==0)addconsole(getactive());

#if __DEBUG__
	printf("Number of added consoles=%d\n",consolesn);
#endif

	/*get next available console*/
	set_acon_id();
	if((i=open("/dev/console",O_RDONLY))==-1)
	{
		printf("Cant open /dev/console\n");
		return 1;
	}
	set_user_id();
	if(ioctl(i,VT_OPENQRY,&tty))
	{
	    puts("Error in acon.c:VT_OPENQRY\n");
	    return 1;
	}
	close(i);
	
	if(tty<8)
	    tty=8;

#if __DEBUG__
	printf("Acon tty number=%d\n",tty);
#endif

	for(i=0;i<63;i++)
		if(isinlist(i)){
#if __DEBUG__
			printf("Initialize console=%d\n",i);
#endif
			loadfontmap(i);
		}
		
	printf("Acon is loaded \n");
			
 	runchild (tty);
	return 0;
}

int user_id;
int acon_id;

void get_ids(void)
{
	user_id=getuid();
	acon_id=geteuid();
}
void set_user_id(void)
{
	seteuid(user_id);
}
void set_acon_id(void)
{
	seteuid(acon_id);
}
