
module ActiveLDAP
 # Configuration
 # 
 # Configuration provides the default settings required for
 # ActiveLDAP to work with your LDAP server. All of these
 # settings can be passed in at initialization time.
 module Configuration
    DEFAULT_CONFIG = {}
    DEFAULT_CONFIG[:host] = '127.0.0.1'
    DEFAULT_CONFIG[:port] = 389
    DEFAULT_CONFIG[:method] = :plain  # :ssl, :tls, :plain allowed

    DEFAULT_CONFIG[:bind_format] = "cn=%s,dc=localdomain"
    DEFAULT_CONFIG[:user] = ENV['USER']
    DEFAULT_CONFIG[:password_block] = nil
    DEFAULT_CONFIG[:password] = nil
    DEFAULT_CONFIG[:store_password] = true
    DEFAULT_CONFIG[:allow_anonymous] = true
    DEFAULT_CONFIG[:sasl_quiet] = false
    DEFAULT_CONFIG[:try_sasl] = false

    DEFAULT_CONFIG[:retries] = 3
    DEFAULT_CONFIG[:retry_wait] = 3
    DEFAULT_CONFIG[:timeout] = 0 # in seconds; 0 <= Never timeout
    # Whether or not to retry on timeouts
    DEFAULT_CONFIG[:retry_on_timeout] = true

    # Whether to return objects by default from find/find_all
    DEFAULT_CONFIG[:return_objects] = false

    DEFAULT_CONFIG[:logger] = nil

    # On connect, this is overriden by the :base argument
    #
    # Set this to LDAP_SCOPE_SUBTREE if you have a LDAP tree where all 
    # objects of the same class living in different parts of the same subtree, but
    # not. LDAP_SCOPE_ONELEVEL is for use when all the objects in your classes live
    # under one shared level (e.g. ou=People,dc=localdomain)
    #
    # This can be overriden on a per class basis in ldap_mapping :scope
    def Base.ldap_scope
      LDAP::LDAP_SCOPE_ONELEVEL
    end

    # On connect, this is overriden by the :base argument
    # Make the return value the string that is your LDAP base
    def Base.base
      'dc=localdomain'
    end

    # This is optionally set to the array of objectClass names
    # that are minimally required for EVERY object on your LDAP server.
    # If you don't want one, set this to [].
    def Base.required_classes
      ['top']
    end
 end
end
