#!/usr/bin/ruby

$:<<'../lib'
require 'test/unit'
require 'activeldap'


class SimpleBindTest < Test::Unit::TestCase

  def test_simple
    assert_nothing_raised() do
      pwb = Proc.new { 'password' }
      ActiveLDAP::Base.close()
      ActiveLDAP::Base.connect(
        :user => 'root',
        :host => '127.0.0.1',
        :port => 389,
        :base => 'dc=localdomain',
        :password_block => pwb, 
        :allow_anonymous => false)
    end
    assert_not_nil(ActiveLDAP::Base.connection, "Checking is the connection was established.")
  end
 
end
