#!/usr/bin/perl -w
#
# $Id: s.GroupConfig.pm 1.11 03/08/25 20:01:28+02:00 robert@zaron.debian.pl $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::GroupConfig;

use strict;
require Exporter;
use Carp;
use AddUser::StdLib qw{%ERRNO};

our @ISA=qw(Exporter);
our @EXPORT=qw(GroupConfig_get_value GroupConfig_update_keywords);


# GroupConfig_get_value($self, $plugin_name, $option)
#
# Get the value from configuration file, and search for keywords, if it dosn't
# exist, look for keywords in the default option value
#
# {{{

sub GroupConfig_get_value
{
        my ($ph, $plugin, $option) = @_;
        my $config   = $ph->{plugins_options}{GroupConfig};
        my $UI       = $ph->{plugins_options}{UI};
        my $verbose  = $ph->{plugins_options}{verbose};
        my $keywords = $ph->{plugins_options}{keywords};

        my $options  = $ph->{plugins_options};
        my $opts     = $ph->{opts};

	my $value;

        # if the options is specified in the configuration file, then search
        # there for keywords
        if (defined $config->val($plugin, $option)) {
                $value = $config->val($plugin, $option);
                return parse_keywords($options, $value);
        } elsif ($opts->{$option}) {
                # this option isn't set, so search for keywords in the default
                # value
                $value = $opts->{$option};
                $value = parse_keywords($options, $value);
                $opts->{$option} = $value;
        }
        
        return undef;
}
                        
# }}}



# GroupConfig_update_keywords($plugins_options_hash_ref, $plugin_name, $option, $value)
#
# {{{

sub GroupConfig_update_keywords
{
        my ($options, $plugin, $option, $value) = @_;
        my $config   = $options->{GroupConfig};
        my $UI       = $options->{UI};
        my $verbose  = $options->{verbose};
        my $keywords = $options->{keywords};

        $keywords->{"$plugin.$option"} = $value;
}

# }}}


	
# parse_keywords($plugins_options_hash_ref, $option_value_to_parse)
#
# Search for keywords, and return the keyword value if found
#
# {{{

sub parse_keywords
{
        my ($options, $look_in_this) = @_;
        my $config   = $options->{GroupConfig};
        my $UI       = $options->{UI};
        my $verbose  = $options->{verbose};
        my $keywords = $options->{keywords};

        # this will help a lot :)
        my @lookup = split(//, $look_in_this);
        # last posision in the string, now it's the beginning
        my $last = 0;
        # trigger, if this variable is set, return the changed string '$return'
        my $changed = 0;

        # -------------------------------------------------------------------
        my ($keyword, $plugin, $value, $cut_operation, $cut_value);
        my ($cut_begin, $cut_end);
        my ($val, @val_split, $val_size);
        my ($position, $length);
        my ($swith, $return);
        # -------------------------------------------------------------------


        while ($look_in_this =~ /(\%\((\w+)\.(\w+)(([-+])(\d+))?\))/g) {

                $keyword = $1;
                $plugin  = $2;
                $value   = $3;
                $cut_operation = $5 ? $5 : undef;
                $cut_value = $6 ? $6 : undef;

                $UI->display("ParseKeywords VERBOSE", "Found keyword [ $keyword ], plugin [ $plugin ] and value [ $value ] ") if ($verbose);

                if(exists $keywords->{"$plugin.$value"}) {

                        $changed = 1;

                        $val = $keywords->{"$plugin.$value"};
                        $UI->display("ParseKeywords VERBOSE", "Got from keywords table: $plugin.$value = $val") if $verbose;
                
                        if($cut_operation) {

                                @val_split = split(//, $val);
                                $val_size = @val_split;
                        
                                if($cut_operation eq "-") {
                                        $cut_begin = $val_size - $cut_value;
                                        $cut_end   = $val_size - 1;
                                } else {
                                        $cut_begin = 0;
                                        $cut_end   = $cut_value - 1;
                                }
                        
                                if($cut_begin < 0 || $cut_end > $val_size) {
                                        $UI->display_error("Fatal ERROR", "You entered wrong number of chars to cut off [ $cut_value ] in keyword [ $keyword ]");
                                        exit ($AddUser::StdLib::ERRNO{'WRONG_KEYWORD'});
                                }
                        
                                $swith = join("", @val_split[$cut_begin..$cut_end]);

                        } else {
                                $swith = $val;
                        }

                        $position = pos($look_in_this);
                        $length = length($keyword);
                        $return .= join("", @lookup[$last .. ($position - $length - 1)]);
                        $return .= $swith;
                        $last = $position;
                        $UI->display("ParseKeywords VERBOSE", "Finished, returning: $swith") if($verbose);

                } else {
                        $UI->display_error("Fatal ERROR", "There is no value for keyword %($plugin.$value)");
                        exit ($AddUser::StdLib::ERRNO{'WRONG_KEYWORD'});
                }
        
        }

        if($changed) {
                return $return;
        } else {
                $UI->display("ParseKeywords VERBOSE", "no keywords found...") if($verbose);
                return $look_in_this;
        }

}

# }}}



1;

__END__
