#
# $Id: s.cdk.pm 1.14 03/08/27 17:53:42+02:00 robert@zaron.debian.pl $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::UI::cdk;

use strict;
use Cdk;
use Text::Wrap;


# simple configuration
my $max_input = '256';


# file handle STDIN is from now on available only from this package,
# to get rid of nasty errors
close(STDERR);



sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	bless \%args, $class;
}


# init
# 
# initialize UI
#
# {{{
sub init
{
        # Load in the Cdk Extension.
        Cdk::init();
}

# }}}


# end
# 
# Cleanup after UI
#
# {{{
sub end
{
        # clean up cdk
        Cdk::end();
}

# }}}


# get_long($plugin, $option, $synopsis, $description, $default)
#
#
# {{{
sub get_long {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
        my $ret;
        
        $desc = wrap('', '', $desc);
        
        my $title = "<C></B/5> $plugname/$optname -- $short <!B!5>\n\n$desc\n\nDefault: </B/32>$def<!B!32>\n\n";

        # Create a new entry object.
        my $entry = new Cdk::Entry ('Label' => "</B/56>${optname}:<!B!56> ",
                                    'Title' => "$title",
                                    'Width' => 30,
                                    'Min' => 0,
                                    'Max' => $max_input,
                                    'Filler' => '_'
                                   );

        $entry->bind('Key' => "KEY_ESC", 'Function' => sub { popupLabel (["<C>Hit CTRL-C to end!</C>"]);});

        $ret = $entry->activate();

        if($ret eq "") {
                return $def;
        } else {
                return $ret;
        }
}

# }}}

# get_single($plugin_name, $option_name, $synopsis, $description, $default, @allowed_set_of_answers)
#
# This is a little bit buggy !, because, it doesn't show description
# (only synopsis), it's cdk fault...
#
# {{{
sub get_single {
	my ($self, $plugname, $optname, $short, $desc, $def, @answers) = @_;
        my $ret;
        
        $desc = wrap('', '', $desc);

        my @title = ("<C></B/5> $plugname/$optname", "", "$short", "");

        foreach my $button (@answers) {
                if($answers[$button] eq $def) {
                        $answers[$button] = "</7> $def <!7>";
                } else {
                        $answers[$button] = " $answers[$button] ";
                }
        }

        my $dialog = new Cdk::Dialog ('Message' => \@title, 'Buttons' => \@answers);

        $dialog->bind('Key' => "KEY_ESC", 'Function' => sub { popupLabel (["<C>Hit CTRL-C to end!</C>"]);});

        $ret = $dialog->activate();
        return $answers[$ret];
}

# }}}


# get_password($plugin, $option, $synopsis, $description, $default)
#
#
# {{{
sub get_password {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
        my $ret;
        
        $desc = wrap('', '', $desc);
        
        my $title = "<C></B/5> PASSWD! $plugname/$optname -- $short <!B!5>\n\n$desc\n\nDefault: </B/32>$def<!B!32>\n\n";

        # Create a new entry object.
        my $entry = new Cdk::Entry ('Label' => "</B/56>${optname}:<!B!56> ",
                                    'Title' => "$title",
                                    'Width' => 30,
                                    'Min' => 0,
                                    'Max' => $max_input,
                                    'Dtype'  => 'VIEWONLY',
                                    'Filler' => '_'
                                   );

        $entry->bind('Key' => "KEY_ESC", 'Function' => sub { popupLabel (["<C>Hit CTRL-C to end!</C>"]);});

        $ret = $entry->activate();

        if($ret eq "") {
                return $def;
        } else {
                return $ret;
        }
}

# }}}


# display($title, $msg)
#
# Display a message
#
# {{{
sub display
{
        my ($self, $title, $msg) = @_;

        chomp($title);
        chomp($msg);

        $msg = wrap('', '', $msg);

        my @message = ("<C></B/5> $title <!B!5>", "", "", " $msg ", "");
        my $label = new Cdk::Label ('Message' => \@message);

        $label->set('BoxAttribute' => "</B>");
        $label->draw();
        $label->wait();

}

# }}}

# display_getkey($title, $msg)
#
# Same as 'display', but it wait's for user to hit anykey [TM]
#
# {{{
#
# This subroutine is an alias for display in case of cdk ui, becouse, cdk
# ALWAYS waits for user to hit a key..
sub display_getkey
{
        my ($self, $title, $msg) = @_;
        return $self->display("$title", "$msg");
}

# }}}

# display_error($title, $msg)
#
# Display an error message
#
# {{{
sub display_error
{
        my ($self, $title, $msg) = @_;

        chomp($title);
        chomp($msg);

        $msg = wrap('', '', $msg);

        my @message = ("<C></B/2> $title <!B!2>", "", "", " </B/4>$msg<!B!4> ", "");
        my $label = new Cdk::Label ('Message' => \@message);

        $label->set('BoxAttribute' => "</B>");
        $label->draw();
        $label->wait();

}

# }}}



1;
