#
# $Id: s.EximConf.pm 1.17 03/11/09 23:04:30+01:00 robert@zaron.debian.pl $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::plugins::EximConf;

use strict;
use AddUser::StdLib;


my $_PLUGIN = 'EximConf';
my $_APIVERSION = 0x1;


# CONFIGURATION: EximConf files
# {{{
my $aliases = '/etc/exim/aliases';
my $remap   = '/etc/exim/remaps/any';
# }}}


# DO NOT EDIT BELOW !

# new
# {{{

sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
                'create_alias' => 'yes',
		'alias_domain' => '',
		'alias_name' => '%(main.login)',
                'remap' => 'yes'
        };

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;
	
        bless \%args, $class;
}

# }}}




# configure
# =========
#
# {{{

sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

        my $value;

	$self->{plugins_options}{docs} = $docs->{options}{option};
	$ui->display($_PLUGIN, $docs->{description}."\n") if $verbose;

        my $alias_file = "$aliases/$self->{opts}{alias_domain}";
        my $remap_file = "$remap";
        my $login = $self->{plugins_options}{login};

	wrapper_getsingle($self, $_PLUGIN, 'create_alias', ('yes', 'no'));

        # if an alias is not going to be created, just exit... no work here
        return $ERRNO{'OK'} if ($self->{opts}{create_alias} eq "no");

	wrapper_getlong($self, $_PLUGIN, 'alias_domain');

        while ($self->{opts}{'alias_domain'} eq "" or $self->{opts}{'alias_domain'} !~ /((\w+)\.(\w+))/) {
                $ui->display_error("EximConf ERROR!", "The alias_domain '$self->{opts}{alias_domain}' is wrong! Plese enter a correct domain name..");
                $self->{opts}{'alias_domain'} = '';
	        wrapper_getlong($self, $_PLUGIN, 'alias_domain');
        }

	wrapper_getlong($self, $_PLUGIN, 'alias_name');

        while ($self->{opts}{'alias_name'} eq "") {
                $ui->display_error("EximConf ERROR!", "Plese Enter alias_name !");
	        wrapper_getlong($self, $_PLUGIN, 'alias_name');
        }

	wrapper_getsingle($self, $_PLUGIN, 'remap', ('yes', 'no'));

	open(FH, '<', $alias_file) || return $ERRNO{'ERROR'};
	if (scalar(grep {/^$self->{opts}{alias_name}:/} <FH>)) {
		close FH;
		return $ERRNO{'DONE'};
	}
	close FH;

	if ($self->{opts}{'remap'} eq 'yes') {
		open(FH, '<', $remap_file) || return $ERRNO{'ERROR'};
		if (scalar(grep {/^$login:\s+$self->{opts}{alias_name}\@$self->{opts}{alias_domain}$/} <FH>)) {
			close FH;
			return $ERRNO{'DONE'};
		}
		close FH;
	}

	return $ERRNO{'OK'};
}

# }}}




# execute
# =======
#
# {{{

sub execute {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};


        # if user dosn't want to create alias and remap mail, do nothing
        if ($self->{opts}{create_alias} eq "no") {
                return $ERRNO{'OK'};
        }

        my $alias_file = "$aliases/$self->{opts}{alias_domain}";
        my $remap_file = "$remap";

        my $login = $self->{plugins_options}{login};

        if (not open(ALIAS, ">> $alias_file")) {
                $ui->display_error("EximConf ERROR!", "File $alias_file isn't writable: $!");
		return $ERRNO{'ERROR'};
        }

        print ALIAS "# Alias created by AddUser-NG for user: $login\n";
        print ALIAS "$self->{opts}{alias_name}:\t\t${login}\n\n";

        close(ALIAS);

        # if user wants to cleate remap entry, do it
        if ($self->{opts}{remap} eq "yes") {

                if ( not open(REMAP, ">> $remap_file")) {
                        $ui->display_error("EximConf ERROR!", "File $remap_file isn't writable: $!");
		        return $ERRNO{'ERROR'};
                }

                print REMAP "# remap for user ${login}, done by AddUser-NG\n";
                print REMAP "${login}:\t\t$self->{opts}{alias_name}\@$self->{opts}{alias_domain}\n\n";

                close(REMAP);
        }

        return $ERRNO{'OK'};
}

# }}}


# rollback
# ========
#
# {{{

sub rollback {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};
        my $line;

        $ui->display_error("EximConf Rollback", "An ERROR occurred, doing rollback..");

        my $alias_file = "$aliases/$self->{opts}{alias_domain}";
        my $remap_file = "$remap";
        my $alias_file_tmp = create_file("/tmp", ".EximConf");
        my $remap_file_tmp = create_file("/tmp", ".EximConf");

        my $login = $self->{plugins_options}{login};

        if (not open(ALIAS_TMP, ">", $alias_file_tmp)) {
                $ui->display_error("EximConf Rollback ERROR!", "Can't open file $alias_file_tmp: $!");
		return $ERRNO{'ERROR'};
        }

        if (not open(REMAP_TMP, ">", $remap_file_tmp)) {
                $ui->display_error("EximConf Rollback ERROR!", "Can't open file $remap_file_tmp: $!");
		return $ERRNO{'ERROR'};
        }

        if (not open(ALIAS, "$alias_file")) {
                $ui->display_error("EximConf ERROR!", "Can't open file $alias_file for reading: $!");
		return $ERRNO{'ERROR'};
        }
        
        if ( not open(REMAP, "$remap_file")) {
                $ui->display_error("EximConf ERROR!", "Can't open file $remap_file for reading: $!");
		return $ERRNO{'ERROR'};
        }

        # first rollback in alias file
        while ($line = <ALIAS>) {
                if ($line =~ /$self->{opts}{alias_name}:\s+${login}/) {
                        $line = "# Error occurred, removed by rolback..\n#$line";
                }
                print ALIAS_TMP "$line";
        }
        
        close ALIAS;
        close ALIAS_TMP;
        
        if ( not au_move ($alias_file_tmp, $alias_file) ) {
                $ui->display_error("EximConf rollback ERROR!", "Can't move file $alias_file_tmp to $alias_file: $!");
                return $ERRNO{'ERROR'};
        }
 
        # and now in remap file
        while ($line = <REMAP>) {
                if ($line =~ /${login}:\s+$self->{opts}{alias_name}\@$self->{opts}{alias_domain}/) {
                        $line = "# Error occurred, removed by rolback..\n#$line";
                }
                print REMAP_TMP "$line";
        }
        
        close REMAP;
        close REMAP_TMP;
        
        if ( not au_move ($remap_file_tmp, $remap_file) ) {
                $ui->display_error("EximConf rollback ERROR!", "Can't move file $remap_file_tmp to $remap_file: $!");
                return $ERRNO{'ERROR'};
        }
 
	return $ERRNO{'OK'};
}

# }}}

1;
