#
# $Id: s.PasswdUser.pm 1.14 03/09/01 23:43:24+02:00 liar@furrynet.org $
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003 Robert Olejnik <robert@zaron.debian.pl>
#

package AddUser::plugins::PasswdUser;

use strict;
use AddUser::StdLib;

my $_PLUGIN = 'PasswdUser';
my $_APIVERSION = 0x1;


# new
# {{{

sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
		'min_password_validity' => 0,
		'max_password_validity' => 9999,
		'advance_warning' => 7,
		'disable_expired_delay' => '',
		'password' => ''};

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

	bless \%args, $class;
}

# }}}




# configure
# =========
#
# {{{

sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

	$self->{plugins_options}{docs} = $docs->{options}{option};
	$ui->display("$_PLUGIN", $docs->{description}."\n") if $verbose;

	wrapper_getlong($self, $_PLUGIN, 'min_password_validity');
	wrapper_getlong($self, $_PLUGIN, 'max_password_validity');
	wrapper_getlong($self, $_PLUGIN, 'advance_warning');
	wrapper_getlong($self, $_PLUGIN, 'disable_expired_delay');
	wrapper_getpassword($self, $_PLUGIN, 'password');

	return $ERRNO{'OK'};
}

# }}}




# execute
# =======
#
# {{{

sub execute {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};
	my $line;

	umask 0077;

	my $tmp = &create_file('/tmp', 'adduser.');

	open(SOUT, '>', $tmp) || return $ERRNO{'ERROR'};
	open(SIN, '/etc/shadow') || return $ERRNO{'ERROR'};
	while ($line = <SIN>) {
		if ($line =~ /^$self->{plugins_options}{login}:/) {
			my @rec = split(/:/, $line);

			my $salt = '';
			for (0..7) {
				$salt .= ('.', '/', 0..9, 'A'..'Z', 'a'..'z')[rand 64];
			}
			$rec[1] = crypt($self->{opts}{password}, '$1$'.$salt.'$');
			if ($self->{opts}{min_password_validity}) {
				$rec[3] = $self->{opts}{min_password_validity};
			}
			if ($self->{opts}{max_password_validity}) {
				$rec[4] = $self->{opts}{max_password_validity};
			}
			if ($self->{opts}{advance_warning}) {
				$rec[5] = $self->{opts}{advance_warning};
			}
			if ($self->{opts}{disable_expired_delay}) {
				$rec[6] = $self->{opts}{disable_expired_delay};
			}
			$line = join ":", @rec;
		}
		print SOUT $line;
	}
	close SIN;
	close SOUT;

	au_move($tmp, '/etc/shadow');

	return $ERRNO{'OK'};
}

# }}}


# rollback
# ========
#
# {{{

sub rollback {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

	$ui->display("Rollback...", "Doing a rollback.");

	#
	# Nothing to do.
	#

	#
	# We don't care about result of the rollback.
	#
	return $ERRNO{'OK'};
}

# }}}

1;
