#!/usr/bin/perl -w
#
# Simple script to convert XMLish plugins documentation into ini-like file.
# 
# Use:
#    ./plugins-to-ini.pl first_plugin.xml second_plugin.xml ...

use strict;
use XML::Simple;
use Text::Wrap;

while ($_ = shift @ARGV) {
	my ($name, $suf) = split(/./);
	my $xml = XMLin($_);
	my @keys = keys %{$xml->{options}{option}};

	print "[$xml->{name}]\n\n";
	print "#\n";
	print join("\n", map { "# $_" } split("\n",
	    wrap('', '', $xml->{description}))), "\n";
	print "#\n\n";

	for my $key (@keys) {
		print "#\n";
		print join("\n", map { "# $_" } split("\n", 
		    wrap('', '', $xml->{options}{option}{$key}{synopsis}))), "\n";
		print "#\n";
		print join("\n", map { "# $_" } split("\n",
		    wrap('', '', $xml->{options}{option}{$key}{description}))), "\n";
		print "#\n";
		print "$key = ", ref $xml->{options}{option}{$key}{default}
		    ? "" : $xml->{options}{option}{$key}{default}, "\n\n";
	}
	print "\n";
}

