// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <QtCore/QCoreApplication>
#include <QtGui/QWidget>

#ifndef ADEPT_PROCESSEVENTS_H
#define ADEPT_PROCESSEVENTS_H

namespace adept {

struct ProcessEvents {
    static int s_busy, s_update;
    static clock_t s_lastclock;

    static void restart() {
        s_update = 0;
        s_lastclock = clock();
    }

    static inline void check( QWidget *update = 0 ) {
        if ( s_update % 20 != 0 || clock() - s_lastclock < CLOCKS_PER_SEC / 5 )
            return;
        s_lastclock = clock();
        s_update ++;
        if ( update )
            update->setUpdatesEnabled( true );
        process();
        if ( update )
            update->setUpdatesEnabled( false );
    }

    static void process() {
        ++ s_busy;
        QCoreApplication::processEvents();
        -- s_busy;
    }

    static bool busy() {
        return s_busy;
    }
};

}

#endif
