// -*- C++ -*- (c) 2005-2008 Petr Rockai <me@mornfall.net>

#include <adept/config.h>
#include <adept/debconf.h> // for Pipe
#include <ept/core/apt.h>

#ifndef RPM
#include <apt-pkg/dpkgpm.h>
#include <string>
#include <vector>
#include <map>

#ifndef DPKGPM_H
#  define DPKGPM_H

namespace adept {

using namespace ept::core;

struct DpkgItem : pkgDPkgPM {
public:
    typedef Item T;
};

struct DpkgHarness {
protected:
    typedef DpkgItem::T Item;
    typedef std::vector< Item > List;

    enum Op { ORemove, OPurge, OConfigure, OInstall };
    Op m_currentOp;
    int m_dpkgFds[2],
        m_scriptPipe[2],
        m_dpkgStdin[2];
    Pipe m_dpkgPipe;
    unsigned m_version;
    std::string m_statusBuffer;
    typedef std::pair< Op, std::string > OpAndStatus;
    typedef std::map< std::pair< OpAndStatus, std::string >, int > SeenOps;
    SeenOps m_seenOps;
    int m_seenOpCount;
    int m_totalOpCount;
    package::Source &pkgs;
    bool m_recover;
    List m_list;
public:
    typedef std::vector< std::string > StringArray;
    virtual bool go( const List & );
    virtual void computeTotals();
    virtual StringArray setupArgs( std::vector<Item>::iterator &I );
    virtual bool forkDpkg( StringArray );
    virtual void forkScript( const char *, bool );
    virtual void runScripts( const char *, bool );
    virtual bool setupChild();
    virtual void setupScript( const char *, bool );
    virtual void dpkgMonitor();
    virtual bool sendV1Pkgs( FILE * );
    virtual bool sendV2Pkgs( FILE * );
    virtual bool feedPackages();
    virtual void updateStatus( std::string pkg, std::string ev, std::string r );
    virtual void handleConffile( std::string conffile, std::string user,
                                 std::string system );

    virtual void tellDpkg( std::string s );
    virtual void recover();

    DpkgHarness( package::Source &s );
    virtual ~DpkgHarness() {}
};

template< typename Harness >
class DPkgPM : public pkgDPkgPM {
protected:
    Harness m_harness;
public:
    DPkgPM ( package::Source &p )
        : pkgDPkgPM( &p.db().state() ), m_harness( p )
    {
    }

    Harness &harness() {
        return m_harness;
    }

    virtual bool Go( int ) {
        return m_harness.go( List );
    }
};

}
#endif

#endif /* ifndef DPKGPM_H */

