// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <ept/core/apt.h>
#include <ept/core/xapian.h>
#include <ept/core/desktop.h>
#include <ept/core/apt/action.h>

#ifndef ADEPT_PACKAGEDATA_H
#define ADEPT_PACKAGEDATA_H

namespace adept {

using namespace ept::core;

struct PackageData {
    AptDatabase db;
    package::Source pkgs;
    record::Source recs;
    xapian::Source xap;
    desktop::Source desk;
    package::ActionList actl;
    PackageData() : pkgs( db ),
                    recs( db ),
                    desk( "/usr/share/app-install/desktop" )
    {}

    void invalidate() {
        db.invalidate();
        pkgs.invalidate();
        recs.invalidate();
        // xap.invalidate();
        desk.invalidate();
    }
};

struct Validator {
    PackageData &d;
    Validator( PackageData &_d ) : d( _d ) {}
    ept::Token validate( ept::Token t ) const {
        t = d.db.validate( t );
        if ( d.pkgs.get< package::AnyVersion >( t ).valid() )
            return t;
        return ept::Token();
    }
};

}

#endif
