//
//	aegis - project change supervisor
//	Copyright (C) 2004-2006 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate project_bogus
//

#include <aecvsserver/file_info.h>
#include <libaegis/input.h>
#include <aecvsserver/module/project_bogu.h>
#include <aecvsserver/server.h>


module_project_bogus::~module_project_bogus()
{
    str_free(projname);
    projname = 0;
}


module_project_bogus::module_project_bogus(string_ty *arg) :
    projname(str_copy(arg))
{
}


void
module_project_bogus::groan(server_ty *sp, const char *caption)
{
    server_error
    (
	sp,
	"%s: project \"%s\": no such project",
	caption,
	projname->str_text
    );
}


void
module_project_bogus::modified(server_ty *sp, string_ty *file_name,
    file_info_ty *fip, input &ip)
{
    groan(sp, "Modified");
}


string_ty *
module_project_bogus::calculate_canonical_name()
    const
{
    // FIXME: memory leak
    return str_from_c("no such project");
}


bool
module_project_bogus::update(server_ty *sp, string_ty *client_side,
    string_ty *server_side, const options &opt)
{
    groan(sp, "update");
    return false;
}


bool
module_project_bogus::checkin(server_ty *sp, string_ty *client_side,
    string_ty *server_side)
{
    groan(sp, "ci");
    return false;
}


bool
module_project_bogus::add(server_ty *sp, string_ty *client_side,
    string_ty *server_side, const options &opt)
{
    groan(sp, "add");
    return false;
}


bool
module_project_bogus::remove(server_ty *sp, string_ty *client_side,
    string_ty *server_side, const options &opt)
{
    groan(sp, "remove");
    return 0;
}


bool
module_project_bogus::is_bogus()
    const
{
    return true;
}
