//
//	aegis - project change supervisor
//	Copyright (C) 1999, 2004, 2005 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to skip unlucky numbers
//

#include <common/skip_unlucky.h>


long
skip_unlucky(long n)
{
    long	    mult;

    //
    // Celtic tradition, I think.  Anyone know its origin?
    //
    if (n == 13)
	++n;

    //
    // Christian tradition: the number of the devil.
    //
    if (n == 666 || n == 69)
	++n;

    //
    // Eastern tradition: the number "4" can sound like "death"
    // if slightly mis-pronounced.
    //
    for (mult = 1; mult < n; mult *= 10)
    {
	long            fudge;

	fudge = n / mult;
	if ((fudge % 10) == 4)
    	    n = (fudge + 1) * mult;
    }
    return n;
}
