/*
    Copyright (C) 2005 Fons Adriaensen <fons.adriaensen@skynet.be>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __MODEL_H
#define __MODEL_H


#include <clthreads.h>
#include "messages.h"
#include "lfqueue.h"
#include "addsynth.h"
#include "rankwave.h"
#include "global.h"


class Asect
{
public:

    Asect (void) { *_label = 0; }

    char    _label [64];
};


class Rank
{
public:

    int         _count;
    Addsynth   *_sdef;
    Rankwave   *_wave;
};

    
class Divis
{
public:

    enum { HAS_SWELL = 1, HAS_TREM = 2, NRANK = 32 };
    enum { SWELL, TFREQ, TMODD, NPARAM };

    Divis (void);

    char        _label [16];
    int         _flags;
    int         _dmask;
    int         _nrank;
    int         _asect;
    int         _keybd;
    Fparm       _param [NPARAM];
    Rank        _ranks [NRANK];
};

    
class Keybd
{
public:

    enum { IS_PEDAL = 256 };

    Keybd (void) : _flags (0) { *_label = 0; }

    char    _label [16];
    int     _flags;
};

    
class Ifelm
{
public:

    enum { DIVRANK, KBDRANK, COUPLER, TREMUL };

    Ifelm (void) : _state (0) { *_label = *_mnemo = 0; }

    char    _label [32];
    char    _mnemo [8];
    int     _type;
    int     _keybd;
    int     _state;
    U32     _action0;
    U32     _action1;
};

    
class Group
{
public:

    enum { NIFELM = 32 };

    Group (void) : _nifelm (0) { *_label = 0; }

    char     _label [16];
    int      _nifelm;
    Ifelm    _ifelms [NIFELM]; 
};


class Chconf
{
public:

    Chconf (void) { memset (_bits, 0, 16 * sizeof (U16)); }

    U16   _bits [16];
};


class Preset
{
public:

    Preset (void) { memset (_bits, 0, NGROUP * sizeof (U32)); }

    U32   _bits [NGROUP];
};

    

class Model : public A_thread
{
public:

    Model (Lfq_u32 *commq, const char *appid, const char *stops, const char *instr, const char *waves, bool uhome);
    virtual ~Model (void);
   
    U16 *chconf (void) const { return (U16 *) _chbits; }
    void terminate (void) {  put_event (EV_EXIT, 1); }

    void print (void);

private:

    virtual void thr_main (void);

    void init (void);
    void fini (void);
    void proc_mesg (ITC_mesg *M);
    void init_audio (void);
    void init_iface (void);
    void init_ranks (int comm);
    void proc_rank (int g, int i, int comm);
    void set_ifelm (int g, int i, int m);
    void clr_group (int g);
    void set_aupar (int s, int a, int p, float v);
    void set_dipar (int s, int d, int p, float v);
    void set_mconf (int i, U16 *d);
    void get_state (U32 *bits);
    void set_state (int bank, int pres);
    void midi_off (int mask);
    void retune (float freq, int temp);
    void recalc (int g, int i);
    void save (void);
    Rank *find_rank (int g, int i);
    int  read_instr (void);
    int  write_instr (void);
    int  get_preset (int bank, int pres, U32 *bits);
    void set_preset (int bank, int pres, U32 *bits);
    void ins_preset (int bank, int pres, U32 *bits);
    void del_preset (int bank, int pres);
    int  read_presets (void);
    int  write_presets (void);

    Lfq_u32        *_commq; 
    const char     *_appid;
    const char     *_stops;
    char            _instr [1024];
    char            _waves [1024];
    bool            _uhome;
    bool            _ready;

    Asect           _asect [NASECT];
    Keybd           _keybd [NKEYBD];
    Divis           _divis [NDIVIS];
    Group           _group [NGROUP];

    int             _nasect;
    int             _ndivis;
    int             _nkeybd;
    int             _ngroup;
    float           _fbase;
    int             _itemp;
    int             _count;
    int             _bank;
    int             _pres;
    int             _client;
    int             _portid;
    U16             _chbits [16];
    Chconf          _chconf [8];
    Preset         *_preset [NBANK][NPRES];
    M_audio_info   *_audio;
    M_midi_info    *_midi;
};


#endif

