/* aewm - An Exiguous Window Manager - vim:sw=4:ts=4:et
 *
 * Copyright 1998-2006 Decklin Foster <decklin@red-bean.com>. This
 * program is free software; please see LICENSE for details. */

#ifndef AEWM_H
#define AEWM_H

#define VERSION "1.3.7"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef XFT
#include <X11/Xft/Xft.h>
#endif
#include "common.h"
#include "atom.h"

/* Default options you may want to change */

#define DEF_FONT "fixed"
#ifdef XFT
#define DEF_XFTFONT "Sans:size=8"
#endif

#define DEF_FG   "white"
#define DEF_BG   "slategray"
#define DEF_BD   "black"
#define DEF_NEW1 "aemenu"
#define DEF_NEW2 "xterm"
#define DEF_NEW3 "aemenu --switch"

#define DEF_BW    1
#define DEF_PAD   3

/* End of options */

#define USAGE \
    "usage: aewm [--config|-rc <file>]\n" \
    "            [--font|-fn <font>]\n" \
    "            [--fgcolor|-fg <color>]\n" \
    "            [--bgcolor|-bg <color>]\n" \
    "            [--bdcolor|-bd <color>]\n" \
    "            [--bdwidth|-bw <integer>]\n" \
    "            [--padding|-p <integer>]\n" \
    "            [-map|-m] [-nomap|-M]\n" \
    "            [--new1|-1 <command>]\n" \
    "            [--new2|-2 <command>]\n" \
    "            [--new3|-3 <command>]\n" \
    "            [--help|-h]\n" \
    "            [--version|-v]\n"

#define SubMask (SubstructureRedirectMask|SubstructureNotifyMask)
#define ButtonMask (ButtonPressMask|ButtonReleaseMask)
#define MouseMask (ButtonMask|PointerMotionMask)

#define BW(c) ((c)->bordered ? opt_bw : 0)
#define CAN_PLACE_SELF(t) ((t) == net_wm_type_dock || \
    (t) == net_wm_type_menu || (t) == net_wm_type_splash || \
    (t) == net_wm_type_desk)
#define HAS_NO_BORDER(t) CAN_PLACE_SELF(t)
#define IS_ON_CUR_DESK(c) IS_ON_DESK((c)->desk, cur_desk)
#define GRAB(w, mask, curs) (XGrabPointer(dpy, w, False, mask, \
    GrabModeAsync, GrabModeAsync, None, curs, CurrentTime) == GrabSuccess)

typedef struct geom geom_t;
struct geom {
    long x;
    long y;
    long w;
    long h;
};

typedef struct client client_t;
struct client {
    client_t    *next;
    char        *name;
    Window      win, frame, trans;
    geom_t      geom, save;
    Colormap    cmap;
    XSizeHints  *size;
    unsigned long      desk;
#ifdef XFT
    XftDraw     *xftdraw;
#endif
#ifdef SHAPE
    Bool        shaped;
#endif
    Bool        shaded;
    Bool        zoomed;
    Bool        titled;
    Bool        bordered;
    int         ignore_unmap;
};

typedef void sweep_func(client_t *, geom_t, int, int, int, int, strut_t *);

enum { MATCH_WINDOW, MATCH_FRAME }; /* find_client */
enum { REMOVE_WITHDRAW, REMOVE_REMAP }; /* remove_client */
enum { SWEEP_UP, SWEEP_DOWN }; /* sweep */

/* init.c */
extern client_t *head;
extern int screen;
extern unsigned long cur_desk;
extern unsigned long ndesks;
#ifdef SHAPE
extern Bool shape;
extern int shape_event;
#endif
extern XFontStruct *font;
#ifdef X_HAVE_UTF8_STRING
extern XFontSet font_set;
#endif
#ifdef XFT
extern XftFont *xftfont;
extern XftColor xft_fg;
#endif
extern Colormap cmap;
extern XColor fg;
extern XColor bg;
extern XColor bd;
extern GC invert_gc;
extern GC string_gc;
extern GC border_gc;
extern Cursor map_curs;
extern Cursor move_curs;
extern Cursor resize_curs;
extern char *opt_font;
#ifdef XFT
extern char *opt_xftfont;
#endif
extern char *opt_fg;
extern char *opt_bg;
extern char *opt_bd;
extern char *opt_new1;
extern char *opt_new2;
extern char *opt_new3;
extern int opt_bw;
extern int opt_pad;
extern int opt_map;
/* event.c */
extern void event_loop(void);
/* map.c */
extern void map_new(Window w);
/* misc.c */
extern void sig_handler(int signum);
extern int handle_xerror(Display *dpy, XErrorEvent *e);
extern int ignore_xerror(Display *dpy, XErrorEvent *e);
extern void goto_desk(int new_desk);
extern void collect_struts(int desk, strut_t *s);
#ifdef DEBUG
extern void show_event(XEvent e);
extern void dump_title(client_t *c, const char *label, char flag);
extern void dump_win(Window w, const char *label, char flag);
extern void dump_info(client_t *c);
extern void dump_geom(client_t *c, const char *label);
extern void dump_removal(client_t *c, int mode);
extern void dump_clients(void);
#endif
/* ops.c */
extern void do_press(client_t *c, int x, int y, int button);
extern void move_win(client_t *c);
extern void resize_win(client_t *c);
extern void set_active(client_t *c);
extern void iconify_win(client_t *c);
extern void do_iconify(client_t *c);
extern void do_deiconify(client_t *c);
extern void shade_win(client_t *c);
extern void zoom_win(client_t *c);
extern void map_desk(client_t *c);
extern int sweep(client_t *c, Cursor curs, sweep_func cb, int mode, strut_t *s);
extern void recalc_map(client_t *c, geom_t orig, int x0, int y0, int x1, int y1, strut_t *s);
extern void recalc_move(client_t *c, geom_t orig, int x0, int y0, int x1, int y1, strut_t *s);
extern void recalc_resize(client_t *c, geom_t orig, int x0, int y0, int x1, int y1, strut_t *s);
/* win.c */
extern client_t *find_client(Window w, int mode);
extern int theight(client_t *c);
extern int set_wm_state(client_t *c, unsigned long state);
extern void handle_net_wm_state_item(client_t *, Atom);
extern void send_config(client_t *c);
extern void send_wm_delete(client_t *c);
extern void remove_client(client_t *c, int mode);
extern void redraw(client_t *c);
extern geom_t frame_geom(client_t *c);
#ifdef SHAPE
extern void set_shape(client_t *c);
#endif
#endif /* AEWM_H */
