#!/usr/bin/python

from xml.dom.minidom import parse, parseString
import time,sys,os
import MySQLdb

mysql = MySQLdb.connect(host="localhost",
                        user=os.getenv("USER"),
                        passwd=os.getenv("MP"),
                        db="project")
cursor = mysql.cursor()

def hexchars(s):
    ret = ""
    for ch in s:
        ret += "%02x" % ord(ch)
    return ret

class AFFILE:
    def __init__(self,fn):
        "Use afxml to read the metadata associated with this AFF file"
        self.xml = parseString(os.popen("afxml "+fn).read())
    def get_segq(self,segname):
        """Return the 8-byte value of a metadata segment
        as a 64-bit signed integer"""
        return int(self.xml.getElementsByTagName(segname)[0].firstChild.wholeText)
    def get_seg(self,segname):
        try:
            elem  = self.xml.getElementsByTagName(segname)[0]
        except IndexError:
            raise KeyError(segname)

        try:
            return int(elem.attributes.get("arg").firstChild.wholeText)
        except AttributeError:
            pass

        val = elem.firstChild.wholeText

        # Check for base64 coding
        try:
            if(elem.attributes.get("coding").firstChild.wholeText == 'base64'):
                import base64
                val = base64.standard_b64decode(val)
        except AttributeError:
            pass
        return val

def was_scsi(af):
    return "da" in af.get_seg("imaging_device")

import re
drive_re = re.compile("(\d+)\.aff")

debug = True

def update(driveid,name,value):
    if(value==""): return                # don't set empties
    
    if(debug):
        print "update drives set "+name+"=%s where driveid=%s" % \
                   (value,driveid)
    cursor.execute("update drives set "+name+"=%s where driveid=%s",
                   (value,driveid))

def process(fn):
    print fn
    sqlmap = {"device_model"    : "model",
              "device_sn"       : "sn"}
    driveid = int(drive_re.search(fn).group(1))
    af = AFFILE(fn)
    update(driveid,"DOA","N")
    for prop in sqlmap.keys():
        try:
            update(driveid,sqlmap[prop],af.get_seg(prop))
        except KeyError:
            pass
    try:
        update(driveid,"image_sectors",int(af.get_seg("imagesize"))/512)
    except KeyError:
        pass
    try:
        update(driveid,"image_zsectors",int(af.get_seg("blanksectors"))/512)
    except KeyError:
        pass
    try:
        update(driveid,"lotid",int(af.get_seg("lotid")))
    except KeyError:
        pass
    try:
        update(driveid,"image_md5hex",hexchars(af.get_seg("md5")))
    except KeyError:
        pass

if(__name__=='__main__'):
    for fn in sys.argv[1:]:
        process(fn)
        
