/*
 * affix.cpp
 *
 * Fix an aff file that is corrupt.
 * Right now, this is done by loping off the last segment.
 */

/*
 * Copyright (c) 2005
 *	Simson L. Garfinkel and Basis Technology, Inc. 
 *      All rights reserved.
 *
 * This code is derrived from software contributed by
 * Simson L. Garfinkel
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Simson L. Garfinkel
 *    and Basis Technology Corp.
 * 4. Neither the name of Simson Garfinkel, Basis Technology, or other
 *    contributors to this program may be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY SIMSON GARFINKEL, BASIS TECHNOLOGY,
 * AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL SIMSON GARFINKEL, BAIS TECHNOLOGy,
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.  
 */


#include "afflib.h"
#include "afflib_i.h"

#include <ctype.h>

#include <zlib.h>
#include <openssl/md5.h>
#include <openssl/sha.h>
#include <assert.h>

#ifdef UNIX
#include <unistd.h>
#include <curses.h>
#include <term.h>
#define HAS_CURSES
#endif

#ifdef WIN32
#include "unix4win32.h"
#include <malloc.h>
#endif

char *progname = "affix";

#define xstr(s) str(s)
#define str(s) #s


int opt_b = 0;


void usage()
{
    printf("usage: %s [options] file1 [...]\n",progname);
    printf("  -b = only report broken files\n");
    printf("      -v = Just print the version number and exit.\n");
    exit(0);
}



int fix(const char *infile)
{
    switch(af_identify_type(infile)){
    case -1:
	perror(infile);
	return 0;
    case 0:
	fprintf(stderr,"%s is not an AFF file\n",infile);
	return 0;
    default:
	;
    }

    if(opt_b==0) printf("%s  ",infile);

    AFFILE *af = af_open(infile,O_RDONLY,0);
    af_rewind_seg(af);			// start at the beginning
    /* Go through the whole file, getting the first 4K of each segment... */
    int r = 0;
    while(1){
	char segname[AF_MAX_NAME_LEN];
	uint64 loc = ftello(af->aseg);
	size_t data_len;
	r = af_get_next_seg(af,segname,sizeof(segname),0,0,&data_len);
	if(r == -1){
	    break;
	}
	if(r<0){
	    printf("error %d at %"I64u": %s\n",r,loc,af->error_str);
	    break;
	}
    }
    af_close(af);
    if(r==-1 && opt_b==0) putchar('\n');
    return 0;
}

int main(int argc,char **argv)
{
    int bflag, ch;
    const char *infile;

    setvbuf(stdout,0,_IONBF,0);		// turn off buffering

    /* Figure out how many cols the screen has... */
    bflag = 0;
    while ((ch = getopt(argc, argv, "bh?v")) != -1) {
	switch (ch) {
	case 'b':
	    opt_b = 1;
	    break;
	case 'h':
	case '?':
	default:
	    usage();
	    break;
	case 'v':
	    printf("%s version %s\n",progname,xstr(AFFLIB_VERSION));
	    exit(0);
	    
	}
    }
    argc -= optind;
    argv += optind;

    if(argc<1){
	usage();
    }


    /* Loop through all of the files */
    while(*argv){
	infile = *argv++;		// get the file
	argc--;				// decrement argument counter
	 
	fix(infile);
    }
}


