<?xml version="1.0"?>

<!-- ====================================================================== -->
<!-- = blok.xsl                                                           = -->
<!-- = afnix documentation xslt with xhtml output : block processing      = -->
<!-- ====================================================================== -->
<!-- = This  program  is  free  software; you  can redistribute it and/or = -->
<!-- = modify it provided that this copyright notice is kept intact.      = -->
<!-- = This program is distributed in the hope that it will be useful but = -->
<!-- = without  any  warranty;  without  even  the  implied  warranty  of = -->
<!-- = merchantability or fitness for  a  particular purpose. In no event = -->
<!-- = shall  the  copyright  holder be liable for any  direct, indirect, = -->
<!-- = incidental  or special  damages arising  in any way out of the use = -->
<!-- = of this software.                                                  = -->
<!-- ====================================================================== -->
<!-- = copyright (c) 2005-2007 - amaury darsch                            = -->
<!-- ====================================================================== -->

<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml">

 <!-- example template -->
 <xsl:template match="example">
   <xsl:choose>
    <xsl:when test="local-name(..)='keyword'">
     <p class="elem">Example</p>
     <pre class="expl">
       <xsl:text>&#x0a;</xsl:text>
       <xsl:apply-templates/>
     </pre>
    </xsl:when>
    <xsl:when test="local-name(..)='object'">
     <p class="elem">Example</p>
     <pre class="expl">
       <xsl:text>&#x0a;</xsl:text>
       <xsl:apply-templates/>
     </pre>
    </xsl:when>
    <xsl:otherwise>
      <pre class="text">
        <xsl:text>&#x0a;</xsl:text>
        <xsl:apply-templates/>
      </pre>
    </xsl:otherwise>
   </xsl:choose>
 </xsl:template>

 <!-- table template -->
 <xsl:template match="table">
  <table class="text">
   <xsl:apply-templates/>
  </table>
 </xsl:template>

 <!-- table head template --> 
 <xsl:template match="thead">
  <thead class="text">
   <xsl:apply-templates/>
  </thead>
 </xsl:template>

 <!-- table body template --> 
 <xsl:template match="tbody">
  <tbody class="text">
   <xsl:apply-templates/>
  </tbody>
 </xsl:template>

 <!-- table row template --> 
 <xsl:template match="tr">
  <tr>
   <xsl:apply-templates/>
  </tr>
 </xsl:template>

 <!-- table data template --> 
 <xsl:template match="td">
  <td class="text">
   <xsl:value-of select="."/>
  </td>
 </xsl:template>

 <!-- list template -->
 <xsl:template match="list">
  <ul class="text">
   <xsl:apply-templates/>
  </ul>
 </xsl:template>

 <!-- item template -->
  <xsl:template match="item">
  <li>
   <xsl:if test="@ref">
    <i class="item"><xsl:value-of select="@ref"/></i><br/>
   </xsl:if>
   <xsl:value-of select="."/>
  </li>
 </xsl:template>

 <!-- client template -->
 <xsl:template match="client">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- opts element -->
 <xsl:template match="opts">
  <p class="elem">Option</p>
  <div class="frame">
  <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- remark template -->
 <xsl:template match="remark">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- keyword template -->
 <xsl:template match="keyword">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- control template -->
 <xsl:template match="control">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- object template -->
 <xsl:template match="object">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- function template -->
 <xsl:template match="function">
  <!-- force the name template -->
  <xsl:call-template name="function.name"/>
  <!-- loop with the rest -->
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- syntax element -->
 <xsl:template match="syntax">
  <p class="elem">Syntax</p>
  <h1 class="elem">
    <xsl:apply-templates/>
  </h1>
 </xsl:template>

 <!-- inherit element -->
 <xsl:template match="inherit">
  <p class="elem">Inheritance</p>
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- constructor element -->
 <xsl:template match="ctor">
  <p class="elem">Constructor</p>
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- constant element -->
 <xsl:template match="constant">
  <p class="elem">Constant</p>
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- operator element -->
 <xsl:template match="operator">
  <p class="elem">Operator</p>
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>

 <!-- method element -->
 <xsl:template match="method">
  <p class="elem">Method</p>
  <div class="frame">
    <xsl:apply-templates/>
  </div>
 </xsl:template>
</xsl:stylesheet>

