<?xml version="1.0"?>

<!-- ====================================================================== -->
<!-- = body.xsl                                                           = -->
<!-- = afnix documentation xslt with xhtml output : body processing       = -->
<!-- ====================================================================== -->
<!-- = This  program  is  free  software; you  can redistribute it and/or = -->
<!-- = modify it provided that this copyright notice is kept intact.      = -->
<!-- = This program is distributed in the hope that it will be useful but = -->
<!-- = without  any  warranty;  without  even  the  implied  warranty  of = -->
<!-- = merchantability or fitness for  a  particular purpose. In no event = -->
<!-- = shall  the  copyright  holder be liable for any  direct, indirect, = -->
<!-- = incidental  or special  damages arising  in any way out of the use = -->
<!-- = of this software.                                                  = -->
<!-- ====================================================================== -->
<!-- = copyright (c) 2005-2007 - amaury darsch                            = -->
<!-- ====================================================================== -->

<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml">

 <!-- body template -->
 <xsl:template match="body">
  <!-- force the body title template -->
  <xsl:call-template name="body.title"/>
  <!-- default body generation -->
  <xsl:if test="$body.xref = 0">
    <xsl:apply-templates/>
  </xsl:if>
  <!-- body with cross references -->
  <xsl:if test="$body.xref">
    <xsl:call-template name="body.xref"/>
  </xsl:if>
 </xsl:template>

 <!-- body title template-->
 <xsl:template name="body.title">
  <xsl:if test="$head.site = 0">
    <p class="title">
      <xsl:value-of select="$info.title"/>
    </p>
    <hr class="title"/>
  </xsl:if>
  <xsl:if test="$head.site">
    <table>
      <colgroup>
        <col width="25%"/>
        <col width="75%"/>
      </colgroup>
      <tr>
        <td class="menu" align="left">
	  <img src="../img/afnix.png" width="105" height="50" alt="AFNIX"/>
        </td>
	<td class="title" align="right">
           <xsl:value-of select="$info.title"/>
	</td>
      </tr>
    </table>
    <div class="head">
      <a href="../index.htm">home</a>   | 
      <a href="../htm/desc.htm">summary</a>  | 
      <a href="../htm/cnts.htm">contents</a> | 
      <a href="../htm/news.htm">news</a>     | 
      <a href="../htm/lipl.htm">license</a>  |
      <a href="../htm/dwld.htm">download</a>
    </div>
  </xsl:if>
 </xsl:template>

 <!-- front matter template -->
 <xsl:template match="front">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- main matter template -->
 <xsl:template match="main">
  <!-- nop -->
  <xsl:apply-templates/>
 </xsl:template>

 <!-- back matter template -->
 <xsl:template match="back">
  <xsl:apply-templates/>
 </xsl:template>

 <!-- synopsis template -->
 <xsl:template match="synopsis">
  <p/>
  <xsl:apply-templates/>
 </xsl:template>

 <!-- chapter template -->
 <xsl:template match="chapter">
  <p/>
  <xsl:apply-templates/>
 </xsl:template>

 <!-- appendix template -->
 <xsl:template match="appendix">
  <p/>
  <xsl:apply-templates/>
 </xsl:template>

 <!-- section template -->
 <xsl:template match="section">
  <p/>
  <xsl:apply-templates/>
 </xsl:template>

 <!-- subsect element -->
 <xsl:template match="subsect">
  <p/>
  <xsl:apply-templates/>
 </xsl:template>

</xsl:stylesheet>

