// ---------------------------------------------------------------------------
// - cdir.hxx                                                                -
// - standard system library - c directory function definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (AFNIX_PLATFORM_PROCID == AFNIX_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

// linux
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_LINUX)
#define  AFNIX_PLATFORM_RDIR "/"
#define  AFNIX_PLATFORM_TDIR "/tmp"
#define  AFNIX_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#endif

// solaris
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_SOLARIS)
#define  AFNIX_PLATFORM_RDIR "/"
#define  AFNIX_PLATFORM_TDIR "/tmp"
#define  AFNIX_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#endif

// freebsd
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_FREEBSD)
#define  AFNIX_PLATFORM_RDIR "/"
#define  AFNIX_PLATFORM_TDIR "/tmp"
#define  AFNIX_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#endif

// freebsd
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_DARWIN)
#define  AFNIX_PLATFORM_RDIR "/"
#define  AFNIX_PLATFORM_TDIR "/tmp"
#define  AFNIX_PLATFORM_DSEP '/'
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#endif
