// ---------------------------------------------------------------------------
// - Libnwg.cpp                                                              -
// - afnix:nwg module - declaration & implementation                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Uri.hpp"
#include "Meta.hpp"
#include "Libnwg.hpp"
#include "Prednwg.hpp"
#include "UriQuery.hpp"
#include "Function.hpp"

namespace afnix {

  // initialize the afnix:nwg module

  Object* init_afnix_nwg (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the afnix:nwg nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* gset = aset->mknset   ("nwg");

    // bind all symbols in the afnix:nwg nameset
    gset->symcst ("Uri",           new Meta (Uri::mknew));
    gset->symcst ("UriQuery",      new Meta (UriQuery::mknew));

    // bind the predicates
    gset->symcst ("uri-p",         new Function (nwg_urip));
    gset->symcst ("mime-p",        new Function (nwg_mimep));
    gset->symcst ("uri-query-p",   new Function (nwg_uriqp));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_nwg (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_nwg (interp, argv);
  }
}
