# ---------------------------------------------------------------------------
# - NWG0001.als                                                             -
# - afnix:nwg module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   uri test unit
# @author amaury darsch

# get the module
interp:library "afnix-nwg"

# check for a simple uri
trans  uri (afnix:nwg:Uri "http://www.afnix.org")
assert true (afnix:nwg:uri-p uri)

# check components
assert "http"            (uri:get-scheme)
assert "www.afnix.org"   (uri:get-authority)
assert ""                (uri:get-path)
assert ""                (uri:get-query)
assert ""                (uri:get-fragment)

# check for a uri with a path
trans  uri (afnix:nwg:Uri "http://www.afnix.org/example")
assert "http"            (uri:get-scheme)
assert "www.afnix.org"   (uri:get-authority)
assert "/example"        (uri:get-path)
assert ""                (uri:get-query)
assert ""                (uri:get-fragment)

# check for a uri with a path and a query
trans  uri (afnix:nwg:Uri "http://www.afnix.org/example?val=hello+world")
assert "http"            (uri:get-scheme)
assert "www.afnix.org"   (uri:get-authority)
assert "/example"        (uri:get-path)
assert "val=hello+world" (uri:get-query)
assert ""                (uri:get-fragment)

# check for a complete uri
trans  uri (afnix:nwg:Uri "http://a.b.org:2000/example?val=hello+world#good")
assert "http"            (uri:get-scheme)
assert "a.b.org:2000"    (uri:get-authority)
assert "/example"        (uri:get-path)
assert "val=hello+world" (uri:get-query)
assert "good"            (uri:get-fragment)
