// ---------------------------------------------------------------------------
// - Sort.hpp                                                                -
// - afnix:txt module - array sorting definition                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_SORT_HPP
#define  AFNIX_SORT_HPP

#ifndef  AFNIX_VECTOR_HPP
#include "Vector.hpp"
#endif
 
namespace afnix {

  /// this file containes the procedure needed to sort a vector which can
  /// operate in ascending mode, descending mode or in lexicographic mode.
  /// @author amaury darsch

  /// sort an array in ascending order
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_qsort_lth (Runnable* robj, Nameset* nset, Cons* args);

  /// sort an array in descending order
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_qsort_gth (Runnable* robj, Nameset* nset, Cons* args);

  /// sort an array in lexicographic order
  /// @param robj the current runnable
  /// @param nset the current nameset
  /// @param args the arguments list
  Object* txt_qsort_lex (Runnable* robj, Nameset* nset, Cons* args);
}

#endif
