// ---------------------------------------------------------------------------
// - XmlDocument.hpp                                                         -
// - afnix:xml module - xml document class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_XMLDOCUMENT_HPP
#define  AFNIX_XMLDOCUMENT_HPP

#ifndef  AFNIX_NAMEABLE_HPP
#include "Nameable.hpp"
#endif

#ifndef  AFNIX_XMLROOT_HPP
#include "XmlRoot.hpp"
#endif

namespace afnix {

  /// The XmlDocument class is the root document class that maintains a
  /// xml document along with its associated tree and other useful
  /// information. Generally the class is constructed with a file name or
  /// a name and an input stream that is used for parsing the input data. 
  /// The document can also be designed by constructing manually the 
  /// document tree. In that case, the document name must be set explicitely.
  /// @author amaury darsch

  class XmlDocument : public Nameable {
  private:
    /// the document name
    String   d_name;
    /// the root node
    XmlRoot* p_root;

  public:
    /// create a default document
    XmlDocument (void);

    /// create an document by name
    /// @param name the document file name
    XmlDocument (const String& name);

    /// create an document by name and stream
    /// @param name the document name
    /// @param is   the input stream to parse
    XmlDocument (const String& name, Input* is);

    /// create an document by name and root node
    /// @param name the document name
    /// @param root the document root node
    XmlDocument (const String& name, XmlRoot* root);

    /// destroy this document
    ~XmlDocument (void);

    /// @return the class name
    String repr (void) const;

   /// make this document a shared object
    void mksho (void);

    /// @return the document name
    String getname (void) const;

    /// set the document name
    /// @param name the name to set
    void setname (const String& name);

    /// @return the document root node
    XmlRoot* getroot (void) const;

  private:
    // make the copy constructor private
    XmlDocument (const XmlDocument& that);
    // make the assignment operator private
    XmlDocument& operator = (const XmlDocument&);

  public:
    /// create an object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
