// ---------------------------------------------------------------------------
// - XmlEref.cpp                                                             -
// - afnix:xml module - xml entity reference node class implementation       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "XmlEref.hpp"
#include "Exception.hpp"

namespace afnix {

  // -------------------------------------------------------------------------
  // - class section                                                         -
  // -------------------------------------------------------------------------

  // create a default eref node

  XmlEref::XmlEref (void) {
  }

  // create a text node by value

  XmlEref::XmlEref (const String& xref) : XmlRef (xref) {
  }

  // return the document class name

  String XmlEref::repr (void) const {
    return "XmlEref";
  }

  // write a eref node to a buffer

  void XmlEref::write (Buffer& buf) const {
    rdlock ();
    try {
      buf.add ("&");
      buf.add (d_xref);
      buf.add (";");
      unlock ();
    } catch (...) {
      unlock ();
      throw;
    }
  }

  // write a eref node to an output stream

  void XmlEref::write (Output& os) const {
    rdlock ();
    try {
      os.write ("&");
      os.write (d_xref);
      os.write (";");
      unlock ();
    } catch (...) {
      unlock ();
      throw;
    }
  }

  // -------------------------------------------------------------------------
  // - object section                                                        -
  // -------------------------------------------------------------------------

  // create a new object in a generic way

  Object* XmlEref::mknew (Vector* argv) {
    long argc = (argv == nilp) ? 0 : argv->length ();
    // check for 0 argument
    if (argc == 0) return new XmlEref;
    // check for 1 argument
    if (argc == 1) {
      String xref = argv->getstring (0);
      return new XmlEref (xref);
    }
    throw Exception ("argument-error",
                     "too many arguments with xml eref node constructor");
  }
}
