// ---------------------------------------------------------------------------
// - Predwam.cpp                                                             -
// - afnix:wam service - predicates implementation                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Cons.hpp"
#include "Cookie.hpp"
#include "Session.hpp"
#include "Predwam.hpp"
#include "Boolean.hpp"
#include "XhtmlHr.hpp"
#include "XhtmlTh.hpp"
#include "XhtmlTd.hpp"
#include "XhtmlTr.hpp"
#include "XhtmlCol.hpp"
#include "XhtmlCgr.hpp"
#include "XhtmlImg.hpp"
#include "XhtmlDiv.hpp"
#include "XhtmlRef.hpp"
#include "HttpReply.hpp"
#include "XhtmlMeta.hpp"
#include "XhtmlRoot.hpp"
#include "XhtmlPara.hpp"
#include "Exception.hpp"
#include "XhtmlThead.hpp"
#include "XhtmlTbody.hpp"
#include "XhtmlTfoot.hpp"
#include "XhtmlTable.hpp"
#include "XhtmlTitle.hpp"
#include "XhtmlStyle.hpp"
#include "XhtmlCaption.hpp"

namespace afnix {

  // this procedure checks that we have one argument only and returns
  // the evaluated object
  static inline Object* get_obj (Runnable* robj, Nameset* nset, Cons* args,
                                 const String& pname) {
    Object* car = nilp;
    if ((args == nilp) || (args->length () != 1))
      throw Exception ("argument-error", "illegal arguments with predicate",
                       pname);
    car = args->getcar ();
    return (car == nilp) ? nilp : car->eval (robj,nset);
  }

  // htprp: http reply object predicate

  Object* wam_htprp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "http-reply-p");
    bool result = (dynamic_cast <HttpReply*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // cookp: http cookie object predicate

  Object* wam_cookp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "cookie-p");
    bool result = (dynamic_cast <Cookie*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }


  // sessp: http session object predicate

  Object* wam_sessp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "session-p");
    bool result = (dynamic_cast <Session*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // rootp: xhtml root object predicate

  Object* wam_rootp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-root-p");
    bool result = (dynamic_cast <XhtmlRoot*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // htmlp: xhtml html object predicate

  Object* wam_htmlp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-html-p");
    bool result = (dynamic_cast <XhtmlHtml*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // headp: xhtml head object predicate

  Object* wam_headp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-head-p");
    bool result = (dynamic_cast <XhtmlHead*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // bodyp: xhtml body object predicate

  Object* wam_bodyp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-body-p");
    bool result = (dynamic_cast <XhtmlBody*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // thp: xhtml th object predicate

  Object* wam_thp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-th-p");
    bool result = (dynamic_cast <XhtmlTh*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // tdp: xhtml td object predicate

  Object* wam_tdp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-td-p");
    bool result = (dynamic_cast <XhtmlTd*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // trp: xhtml tr object predicate

  Object* wam_trp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-tr-p");
    bool result = (dynamic_cast <XhtmlTr*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // colp: xhtml col object predicate

  Object* wam_colp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-col-p");
    bool result = (dynamic_cast <XhtmlCol*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // cgrp: xhtml cgr object predicate

  Object* wam_cgrp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-cgr-p");
    bool result = (dynamic_cast <XhtmlCgr*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // captp: xhtml caption object predicate
  
  Object* wam_captp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-caption-p");
    bool result = (dynamic_cast <XhtmlCaption*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // telemp: xhtml table element object predicate

  Object* wam_telemp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-telem-p");
    bool result = (dynamic_cast <XhtmlTelem*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // theadp: xhtml table head object predicate

  Object* wam_theadp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-thead-p");
    bool result = (dynamic_cast <XhtmlThead*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // tbodyp: xhtml table body object predicate

  Object* wam_tbodyp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-tbody-p");
    bool result = (dynamic_cast <XhtmlTbody*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // tfootp: xhtml table foot object predicate

  Object* wam_tfootp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-ttoot-p");
    bool result = (dynamic_cast <XhtmlTfoot*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // tablep: xhtml table object predicate

  Object* wam_tablep  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-table-p");
    bool result = (dynamic_cast <XhtmlTable*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // titlep: xhtml title object predicate

  Object* wam_titlep  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-title-p");
    bool result = (dynamic_cast <XhtmlTitle*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // metap: xhtml meta object predicate

  Object* wam_metap  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-meta-p");
    bool result = (dynamic_cast <XhtmlMeta*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // stylep: xhtml style object predicate

  Object* wam_stylep  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-style-p");
    bool result = (dynamic_cast <XhtmlStyle*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // imgp: xhtml img object predicate

  Object* wam_imgp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-img-p");
    bool result = (dynamic_cast <XhtmlImg*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // divp: xhtml div object predicate

  Object* wam_divp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-div-p");
    bool result = (dynamic_cast <XhtmlDiv*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // refp: xhtml ref object predicate

  Object* wam_refp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-ref-p");
    bool result = (dynamic_cast <XhtmlRef*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // parap: xhtml paragraph object predicate

  Object* wam_parap  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-para-p");
    bool result = (dynamic_cast <XhtmlPara*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }

  // hrp: xhtml hr object predicate

  Object* wam_hrp  (Runnable* robj, Nameset* nset, Cons* args) {
    Object* obj = get_obj (robj, nset, args, "xhtml-hr-p");
    bool result = (dynamic_cast <XhtmlHr*> (obj) == nilp) ? false : true;
    Object::cref (obj);
    return new Boolean (result);
  }
}
