// ---------------------------------------------------------------------------
// - XhtmlTitle.cpp                                                          -
// - afnix:wam module - xhtml title node class implementation                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "XmlText.hpp"
#include "XhtmlTitle.hpp"
#include "Exception.hpp"

namespace afnix {

  // -------------------------------------------------------------------------
  // - private section                                                       -
  // -------------------------------------------------------------------------

  // the title node name
  static const String XML_TAG_NAME = "title";

  // -------------------------------------------------------------------------
  // - class section                                                         -
  // -------------------------------------------------------------------------

  // create a xhtml title node by title

  XhtmlTitle::XhtmlTitle (const String& title) : XmlTag (XML_TAG_NAME) {
    addchild (new XmlText (title));
  }

  // return the class name

  String XhtmlTitle::repr (void) const {
    return "XhtmlTitle";
  }

  // -------------------------------------------------------------------------
  // - object section                                                        -
  // -------------------------------------------------------------------------

  // create a new object in a generic way

  Object* XhtmlTitle::mknew (Vector* argv) {
    long argc = (argv == nilp) ? 0 : argv->length ();
    // check for 1 argument
    if (argc == 1) {
      String title = argv->getstring (0);
      return new XhtmlTitle (title);
    }
    // wrong arguments
    throw Exception ("argument-error", 
		     "too many arguments with xhtml title constructor");
  }
}
