# ---------------------------------------------------------------------------
# - WAM0002.als                                                             -
# - afnix:wam module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   cookie test unit
# @author amaury darsch

# get the module
interp:library "afnix-wam"

# create a new cookie
const  cookie (afnix:wam:Cookie "name" "value")
assert true   (afnix:wam:cookie-p cookie)

# and now check everything
assert "name"  (cookie:get-name)
assert "value" (cookie:get-value)
assert  1      (cookie:get-version)
assert -1      (cookie:get-max-age)
assert -1      (cookie:get-port)

# check cookie value
assert "name=\"value\"; Version=\"1\"" (cookie:to-string)

# check for max age
cookie:set-max-age 60
assert 60 (cookie:get-max-age)

# check for comment
cookie:set-comment "hello world"
assert "hello world" (cookie:get-comment)

# check for comment url
cookie:set-comment-url "http://hello"
assert "http://hello" (cookie:get-comment-url)

# check for path
cookie:set-path "/cgi"
assert "/cgi" (cookie:get-path)

# check for domain
cookie:set-domain "afnix.org"
assert "afnix.org" (cookie:get-domain)

# check for port
cookie:set-port 80
assert 80 (cookie:get-port)

# check for discard
assert false (cookie:get-discard)

# check for secure
assert false (cookie:get-secure)

