// ---------------------------------------------------------------------------
// - Return.cpp                                                              -
// - afnix engine - return exception class implementation                    -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "String.hpp"
#include "Return.hpp"

namespace afnix {

  // -------------------------------------------------------------------------
  // - class section                                                         -
  // -------------------------------------------------------------------------

  // create a default return object

  Return::Return (void) {
    p_object = nilp;
  }

  // create a return object with an object

  Return::Return (Object* object) {
    p_object = Object::iref (object);
  }

  // copy constructor for this returned object
  
  Return::Return (const Return& that) {
    that.rdlock ();
    p_object = Object::iref (that.p_object);
    that.unlock ();
  }

  // destroy this return object

  Return::~Return (void) {
    Object::dref (p_object);
  }

  // return the class name

  String Return::repr (void) const {
    return "Return";
  }

  // throw an exception if attempt to make shared

  void Return::mksho (void) {
    if (p_shared != nilp) return;
    Object::mksho ();
    if (p_object != nilp) p_object->mksho ();
  }

  // return the returned object
    
  Object* Return::getobj (void) const {
    rdlock ();
    Object* result = p_object;
    unlock ();
    return result;
  }
}
