// ---------------------------------------------------------------------------
// - Property.hpp                                                            -
// - standard object library - property class definition                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef AFNIX_PROPERTY_HPP
#define AFNIX_PROPERTY_HPP

#ifndef  AFNIX_STRING_HPP
#include "String.hpp"
#endif

namespace afnix {

  /// The Property class is a simple name/value pair. The property object
  /// is designed to operate with a propertty list but this is not mandatory.
  /// @author amaury darsch

  class Property: public Serial {
  private:
    /// the property name
    String d_name;
    /// the property value
    String d_pval;

  public:
    /// create a default property
    Property (void);

    /// create a new property by name
    /// @param name the property name
    Property (const String& name);

    /// create a new property byname and value
    /// @param name the property name
    /// @param lval the property value
    Property (const String& name, const Literal& pval);

    /// copy construct this property
    /// @param that the property class to copy
    Property (const Property& that);

    /// @return the class name
    String repr (void) const;

    /// @return a clone of this property
    Object* clone (void) const;

    /// @return the property serial code
    t_byte serialid (void) const;

    /// serialize this property to an output stream
    /// @param os the output stream to write
    void wrstream (class Output& os) const;

    /// deserialize a property from an input stream
    /// @param is the input steam to read in
    void rdstream (class Input& is);

    /// assign a property with a property value
    /// @param value the value to assign
    Property& operator = (const Property& value);

    /// set the property name
    /// @param name the property name to set
    void setname (const String& name);

    /// @return the property name
    String getname (void) const;

    /// set the property value
    /// @param lval the literal value to set
    void setpval (const Literal& lval);

    /// @return the property value
    String getpval (void) const;

    ///set the property  pair at once
    /// @param name the property name to set
    /// @param lval the literal value to set
    void set (const String& name, const Literal& lval);

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the name to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
