// ---------------------------------------------------------------------------
// - t_sha384.cpp                                                            -
// - afnix cryptography - SHA-384 class tester module                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Sha384.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a SHA-384 message digest
  Sha384 md;
  if (md.getname () != "SHA-384") return 1;

  // check digest as specified in FIPS PUB 180-2
  String digest = md.compute ("abc");
  if (digest != "CB00753F45A35E8B" "B5A03D699AC65007" 
                "272C32AB0EDED163" "1A8B605A43FF5BED"
                "8086072BA1E7CC23" "58BAECA134C825A7") return 1;

  // the afnix test as usual
  digest = md.compute ("afnix");
  if (digest != "33ABEC90674F5DC0" "823578EF189498FF"
                "8B98B8A82FB7CEFD" "ACBF39428AAD0321"
                "3ADCDC1317E884A8" "6A9DEBD2FFF6B3D4") return 1;

  digest = md.compute ("afnix programming language");
  if (digest != "57A06A41BB6D511C" "8A3F438DE77896A7"
                "D501DB0F7948495D" "8B3CD1F0F9839652"
                "1FC902465A492BDA" "79F6D91C57FCCDCA") return 1;
  // success
  return 0;
}
