/*******************************************************************************
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#include "config.h"
#include "gcs-conf.h"
#ifdef HAVE_GCONFMM
#include <gconfmm/client.h>
#endif // HAVE_GCONFMM

namespace gcs
{
    const Glib::ustring Conf::APP_DIR = "/apps/agave";
    const Glib::ustring Conf::KEY_LAST_SAVE_DIR = Conf::APP_DIR + "/last_save_directory";
    const Glib::ustring Conf::KEY_LAST_COLOR = Conf::APP_DIR + "/last_color";
    const Glib::ustring Conf::KEY_LAST_SCHEME_TYPE = Conf::APP_DIR + "/last_scheme_type";

    const Glib::ustring Conf::KEY_WINDOW_WIDTH = Conf::APP_DIR + "/window_width";
    const Glib::ustring Conf::KEY_WINDOW_HEIGHT = Conf::APP_DIR + "/window_height";

    const Glib::ustring Conf::GCS_CONF_DIR = ".agave";
    const Glib::ustring Conf::FAVORITES_FILE = Conf::GCS_CONF_DIR + "/bookmarks.gpl";

    const int Conf::WINDOW_BORDER = 12;
    const int Conf::UI_SPACING_SMALL = 6;
    const int Conf::UI_SPACING_MEDIUM = 12;
    const int Conf::UI_SPACING_LARGE = 18;

    Glib::ustring Conf::get_last_save_dir(void)
    {
        std::string dir;
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();

        Gnome::Conf::Value val = ref_client->get(KEY_LAST_SAVE_DIR);
        if (val.get_type() == Gnome::Conf::VALUE_INVALID)
        {
            dir = Glib::filename_to_uri(Glib::get_current_dir());
        }
        else
        {
            dir = val.get_string();
        }
#endif // HAVE_GCONFMM

        return dir;
    }


    void Conf::set_last_save_dir(Glib::ustring uri)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        if (!uri.empty())
        {
            ref_client->set(Conf::KEY_LAST_SAVE_DIR, uri);
        }
#endif // HAVE_GCONFMM
    }


    ColorPtr Conf::get_last_color(void)
    {
        std::string clr;
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();

        Gnome::Conf::Value val = ref_client->get(KEY_LAST_COLOR);
        if (val.get_type() != Gnome::Conf::VALUE_INVALID)
        {
            clr = val.get_string();
        }
        else
#endif // HAVE_GCONFMM
        {
            clr = "#9DFF00";
        }
        return Color::create(clr);
    }


    void Conf::set_last_color(ColorPtr clr)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        ref_client->set(Conf::KEY_LAST_COLOR, clr->get_hexstring());
#endif // HAVE_GCONFMM
    }


    void Conf::set_last_scheme_type(tSchemeType t)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        ref_client->set(Conf::KEY_LAST_SCHEME_TYPE, t);
#endif // HAVE_GCONFMM
    }


    tSchemeType Conf::get_last_scheme_type(void)
    {
        tSchemeType t;
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();

        Gnome::Conf::Value val = ref_client->get(KEY_LAST_SCHEME_TYPE);
        if (val.get_type() != Gnome::Conf::VALUE_INVALID)
        {
            t = static_cast<tSchemeType>(val.get_int());
        }
        else
#endif // HAVE_GCONFMM
        {
            t = SCHEME_TRIADS;
        }
        return t;
    }


    Glib::ustring Conf::get_favorites_file(void)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
#endif // HAVE_GCONFMM
    }


    Glib::ustring Conf::get_conf_dir(void)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
#endif // HAVE_GCONFMM
    }


    int Conf::get_window_width(void)
    {
        int w;
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        Gnome::Conf::Value val = ref_client->get(KEY_WINDOW_WIDTH);

        if (val.get_type() != Gnome::Conf::VALUE_INVALID)
        {
            w = val.get_int();
        }
        else
#endif // HAVE_GCONFMM
        {
            w = 650;
        }
        return w;
    }


    void Conf::set_window_width(int w)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        ref_client->set(KEY_WINDOW_WIDTH, w);
#endif // HAVE_GCONFMM
    }


    int Conf::get_window_height(void)
    {
        int h;
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        Gnome::Conf::Value val = ref_client->get(KEY_WINDOW_HEIGHT);
        if (val.get_type() != Gnome::Conf::VALUE_INVALID)
        {
            h = val.get_int();
        }
        else
#endif // HAVE_GCONFMM
        {
            h = 400;
        }
        return h;
    }


    void Conf::set_window_height(int h)
    {
#ifdef HAVE_GCONFMM
        Glib::RefPtr<Gnome::Conf::Client> ref_client =
            Gnome::Conf::Client::get_default_client();
        ref_client->set(KEY_WINDOW_HEIGHT, h);
#endif // HAVE_GCONFMM
    }


} // namespace gcs
