/*******************************************************************************
 *  PROJECT: Agave
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2006 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __PALETTETREEMODEL_H
#define __PALETTETREEMODEL_H

#include <gtkmm/treemodel.h>
#include <vector>
#include "customtreemodel.h"
#include "paletteparser/palette.h"

namespace gcs
{

    class PaletteTreeModel: public Glib::Object,
                            public ::ContainerTreeModel<pp::Palette>
    {
        public:
            typedef pp::Palette value_type;
            typedef Gtk::TreeModelColumn<Glib::ustring> name_column_type;
            typedef Gtk::TreeModelColumn<ColorPtr> color_column_type;
            static Glib::RefPtr<PaletteTreeModel> create(value_type& val);
            name_column_type& get_text_column(void) { return m_text_column; }
            color_column_type& get_color_column(void) { return m_color_column; }
            Gtk::TreeModel::Row append(ColorPtr& color);
            Gtk::TreeModel::Row insert(const Gtk::TreeModel::iterator& iter, ColorPtr& color);
            void clear(void);
            iterator erase(iterator& iter);

        protected:
            PaletteTreeModel(value_type& palette);
            virtual int get_n_columns_vfunc(void) const;
            virtual GType get_column_type_vfunc(int index) const;
            virtual void get_value_vfunc(const Gtk::TreeModel::iterator& iter, int column, Glib::ValueBase& value) const;
            virtual void set_value_impl(const iterator& row, int column, const Glib::ValueBase& value);

            // virtual functions from Gtk::TreeDragSource
            virtual bool drag_data_delete_vfunc(const Gtk::TreeModel::Path& path);
            virtual bool drag_data_get_vfunc(const Gtk::TreeModel::Path& path, Gtk::SelectionData& selection_data) const;
            // virtual functions from Gtk::TreeDragDest
            virtual bool drag_data_received_vfunc(const Gtk::TreeModel::Path& dest, const Gtk::SelectionData& selection_data);

        private:
            name_column_type m_text_column;
            color_column_type m_color_column;

            static std::string m_dragDataType;
    };


} // namespace gcs
#endif // __PALETTETREEMODEL_H
