{-# OPTIONS -fglasgow-exts -cpp #-}
{-# LINE 1 "src/full/Agda/Syntax/Parser/Lexer.x" #-}

{-| The lexer is generated by Alex (<http://www.haskell.org/alex>) and is an
    adaptation of GHC's lexer. The main lexing function 'lexer' is called by
    the "Agda.Syntax.Parser.Parser" to get the next token from the input.
-}
module Agda.Syntax.Parser.Lexer
    ( -- * The main function
      lexer
      -- * Lex states
    , normal, literate, code
    , layout, empty_layout, bol, imp_dir
      -- * Alex generated functions
    , AlexReturn(..), alexScanUser
    ) where

import Data.List

import Agda.Syntax.Parser.Alex
import Agda.Syntax.Parser.Comments
#ifndef __HADDOCK__
import {-# SOURCE #-} Agda.Syntax.Parser.Layout
import {-# SOURCE #-} Agda.Syntax.Parser.LexActions
#endif
import Agda.Syntax.Parser.Monad
import Agda.Syntax.Parser.StringLiterals
import Agda.Syntax.Parser.Tokens
import Agda.Syntax.Literal


#if __GLASGOW_HASKELL__ >= 603
#include "ghcconfig.h"
#elif defined(__GLASGOW_HASKELL__)
#include "config.h"
#endif
#if __GLASGOW_HASKELL__ >= 503
import Data.Array
import Data.Char (ord)
import Data.Array.Base (unsafeAt)
#else
import Array
import Char (ord)
#endif
#if __GLASGOW_HASKELL__ >= 503
import GHC.Exts
#else
import GlaExts
#endif
alex_base :: AlexAddr
alex_base = AlexA# "\xf7\xff\xff\xff\x6c\x00\x00\x00\xc8\x00\x00\x00\x3c\x01\x00\x00\x40\x01\x00\x00\x44\x01\x00\x00\x4b\x01\x00\x00\x70\x00\x00\x00\x73\x00\x00\x00\x76\x00\x00\x00\x7a\x00\x00\x00\x7d\x00\x00\x00\x94\x00\x00\x00\xa3\xff\xff\xff\x81\x00\x00\x00\x82\x00\x00\x00\x68\x01\x00\x00\xa1\xff\xff\xff\x48\x01\x00\x00\xa0\xff\xff\xff\x49\x01\x00\x00\x9f\xff\xff\xff\x4f\x01\x00\x00\x9b\xff\xff\xff\x50\x01\x00\x00\x8f\xff\xff\xff\x51\x01\x00\x00\xa8\xff\xff\xff\x53\x01\x00\x00\x9d\xff\xff\xff\x54\x01\x00\x00\xa9\xff\xff\xff\x55\x01\x00\x00\xaa\xff\xff\xff\x57\x01\x00\x00\x91\xff\xff\xff\x58\x01\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\xff\xff\xff\xa6\xff\xff\xff\xb1\xff\xff\xff\x16\x00\x00\x00\xb3\xff\xff\xff\x23\x00\x00\x00\x30\x00\x00\x00\x32\x00\x00\x00\x18\x00\x00\x00\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x75\x00\x00\x00\xa0\x00\x00\x00\xb0\x00\x00\x00\xa6\x00\x00\x00\xb8\x00\x00\x00\x6f\x01\x00\x00\x75\x01\x00\x00\x9a\x01\x00\x00\xbe\x01\x00\x00\xc4\x01\x00\x00\xcd\x01\x00\x00\xd6\x01\x00\x00\xdc\x01\x00\x00\xf4\x01\x00\x00\xf9\x01\x00\x00\xfe\x01\x00\x00\x06\x02\x00\x00\x16\x02\x00\x00\x22\x02\x00\x00\x28\x02\x00\x00\x2e\x02\x00\x00\x34\x02\x00\x00\x40\x02\x00\x00\x4c\x02\x00\x00\x52\x02\x00\x00\x5a\x02\x00\x00\x74\x02\x00\x00\x7a\x02\x00\x00\x7f\x02\x00\x00\x9b\x02\x00\x00\xa1\x02\x00\x00\xa6\x02\x00\x00\xab\x02\x00\x00\xc3\x02\x00\x00\xc8\x02\x00\x00\xcd\x02\x00\x00\xd2\x02\x00\x00\xfc\x02\x00\x00\x01\x03\x00\x00\x07\x03\x00\x00\x0c\x03\x00\x00\x24\x03\x00\x00\x29\x03\x00\x00\x2e\x03\x00\x00\x33\x03\x00\x00\x4c\x03\x00\x00\x54\x03\x00\x00\x59\x03\x00\x00\x5e\x03\x00\x00\x64\x03\x00\x00\x7c\x03\x00\x00\x81\x03\x00\x00\x86\x03\x00\x00\x8b\x03\x00\x00\xa3\x03\x00\x00\x00\x00\x00\x00\x6e\x00\x00\x00\x9c\x00\x00\x00\xb2\x03\x00\x00\x9d\x00\x00\x00\x23\x04\x00\x00\x94\x04\x00\x00\x05\x05\x00\x00\x76\x05\x00\x00\xe7\x05\x00\x00\x43\x06\x00\x00\x88\x00\x00\x00\x9f\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfb\x06\x00\x00\x57\x07\x00\x00\xb3\x07\x00\x00\x0f\x08\x00\x00\x6b\x08\x00\x00\xc7\x08\x00\x00\x23\x09\x00\x00\x7f\x09\x00\x00\xdb\x09\x00\x00\x37\x0a\x00\x00\x93\x0a\x00\x00\xef\x0a\x00\x00\x4b\x0b\x00\x00\xa7\x0b\x00\x00\x03\x0c\x00\x00\x5f\x0c\x00\x00\xbb\x0c\x00\x00\x17\x0d\x00\x00\x73\x0d\x00\x00\xcf\x0d\x00\x00\x2b\x0e\x00\x00\x87\x0e\x00\x00\xe3\x0e\x00\x00\x3f\x0f\x00\x00\x9b\x0f\x00\x00\xf7\x0f\x00\x00\x53\x10\x00\x00\xaf\x10\x00\x00\x0b\x11\x00\x00\x67\x11\x00\x00\xc3\x11\x00\x00\x1f\x12\x00\x00\x7b\x12\x00\x00\xd7\x12\x00\x00\x33\x13\x00\x00\x8f\x13\x00\x00\xeb\x13\x00\x00\x47\x14\x00\x00\xa3\x14\x00\x00\xff\x14\x00\x00\x5b\x15\x00\x00\xb7\x15\x00\x00\x13\x16\x00\x00\x6f\x16\x00\x00\xcb\x16\x00\x00\x27\x17\x00\x00\x83\x17\x00\x00\xdf\x17\x00\x00\x3b\x18\x00\x00\x97\x18\x00\x00\xf3\x18\x00\x00\x4f\x19\x00\x00\xab\x19\x00\x00\x07\x1a\x00\x00\x63\x1a\x00\x00\xbf\x1a\x00\x00\x1b\x1b\x00\x00\x77\x1b\x00\x00\xd3\x1b\x00\x00\x2f\x1c\x00\x00\x8b\x1c\x00\x00\xe7\x1c\x00\x00\x43\x1d\x00\x00\x9f\x1d\x00\x00\xfb\x1d\x00\x00\x57\x1e\x00\x00\xb3\x1e\x00\x00\x0f\x1f\x00\x00\x6b\x1f\x00\x00\xc7\x1f\x00\x00\x23\x20\x00\x00\x7f\x20\x00\x00\xdb\x20\x00\x00\x37\x21\x00\x00\x93\x21\x00\x00\xef\x21\x00\x00\x4b\x22\x00\x00\xa7\x22\x00\x00\x03\x23\x00\x00\x5f\x23\x00\x00\xbb\x23\x00\x00\x17\x24\x00\x00\x73\x24\x00\x00\xcf\x24\x00\x00\x2b\x25\x00\x00\x87\x25\x00\x00\xe3\x25\x00\x00\x3f\x26\x00\x00\x9b\x26\x00\x00\xf7\x26\x00\x00\x53\x27\x00\x00\xaf\x27\x00\x00\x0b\x28\x00\x00\x67\x28\x00\x00\xc3\x28\x00\x00\x1f\x29\x00\x00\x7b\x29\x00\x00\xd7\x29\x00\x00\x33\x2a\x00\x00\x8f\x2a\x00\x00\xeb\x2a\x00\x00\x47\x2b\x00\x00\xa3\x2b\x00\x00\xff\x2b\x00\x00\x5b\x2c\x00\x00\xb7\x2c\x00\x00\x13\x2d\x00\x00\x6f\x2d\x00\x00\xcb\x2d\x00\x00\x27\x2e\x00\x00\x83\x2e\x00\x00\xdf\x2e\x00\x00\x3b\x2f\x00\x00\x97\x2f\x00\x00\xf3\x2f\x00\x00\x4f\x30\x00\x00\xab\x30\x00\x00\x07\x31\x00\x00\x63\x31\x00\x00\xbf\x31\x00\x00\x1b\x32\x00\x00\x77\x32\x00\x00\xd3\x32\x00\x00\x2f\x33\x00\x00\x8b\x33\x00\x00\xe7\x33\x00\x00\x43\x34\x00\x00\x9f\x34\x00\x00\xfb\x34\x00\x00\x57\x35\x00\x00\xb3\x35\x00\x00\x0f\x36\x00\x00\x6b\x36\x00\x00\xc7\x36\x00\x00\x23\x37\x00\x00\x00\x00\x00\x00\x3f\x00\x00\x00\x7f\x37\x00\x00\xdb\x37\x00\x00\x37\x38\x00\x00\x93\x38\x00\x00\xef\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00\x4b\x39\x00\x00\xa7\x39\x00\x00\x03\x3a\x00\x00\x5f\x3a\x00\x00\xbb\x3a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x3b\x00\x00\x73\x3b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x3b\x00\x00\x2b\x3c\x00\x00\x87\x3c\x00\x00\xe3\x3c\x00\x00\x3f\x3d\x00\x00\x9b\x3d\x00\x00\xf7\x3d\x00\x00\x53\x3e\x00\x00\xaf\x3e\x00\x00\x0b\x3f\x00\x00\x67\x3f\x00\x00\xc3\x3f\x00\x00\x1f\x40\x00\x00\x7b\x40\x00\x00\xd7\x40\x00\x00\x33\x41\x00\x00\x8f\x41\x00\x00\xeb\x41\x00\x00\x47\x42\x00\x00\xa3\x42\x00\x00\xff\x42\x00\x00\x5b\x43\x00\x00\xb7\x43\x00\x00\x13\x44\x00\x00\x6f\x44\x00\x00\xcb\x44\x00\x00\x27\x45\x00\x00\x83\x45\x00\x00\xdf\x45\x00\x00\x3b\x46\x00\x00\x97\x46\x00\x00\xf3\x46\x00\x00\x4f\x47\x00\x00\xab\x47\x00\x00\x07\x48\x00\x00"#

alex_table :: AlexAddr
alex_table = AlexA# "\x00\x00\x7d\x00\x35\x00\x35\x00\x35\x00\x11\x00\x13\x00\x15\x00\x17\x00\x19\x00\x1b\x00\x1d\x00\x1f\x00\x21\x00\x09\x00\x23\x00\x26\x00\xff\xff\x29\x00\x2d\x00\x2e\x00\x2f\x00\x31\x00\x35\x00\x3d\x01\x1f\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x1e\x01\x18\x01\x19\x01\x3d\x01\x3d\x01\x3d\x01\x7c\x00\x10\x01\x3d\x01\x20\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x13\x01\x12\x01\x3d\x01\x14\x01\x3d\x01\x16\x01\x1c\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\xec\x00\x3d\x01\x3d\x01\xe8\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x1b\x01\x3d\x01\x3d\x01\x15\x01\x3d\x01\xe1\x00\x3d\x01\xc2\x00\xbc\x00\x3d\x01\x8e\x00\x3d\x01\x00\x01\x84\x00\x3d\x01\x3d\x01\x82\x00\xb8\x00\x3d\x01\xad\x00\xa1\x00\x3d\x01\x98\x00\x3d\x01\x3d\x01\xfa\x00\x3d\x01\x89\x00\x3d\x01\x3d\x01\x3d\x01\x38\x00\x17\x01\x1d\x01\x3d\x01\x7e\x00\x35\x00\x35\x00\x35\x00\x2a\x00\x10\x00\x10\x00\x10\x00\x0f\x00\x0f\x00\x0f\x00\x0b\x00\x0b\x00\x0b\x00\xff\xff\x0c\x00\x0c\x00\x0c\x00\x0b\x00\x0b\x00\x0b\x00\xff\xff\x35\x00\x0f\x00\x0f\x00\x0f\x00\x10\x00\x30\x00\x32\x00\x0f\x00\x33\x00\x2b\x00\x0b\x00\x34\x00\x37\x00\x7b\x00\x0c\x00\x70\x00\x0e\x01\x0b\x00\xff\xff\x0c\x00\x0c\x00\x0c\x00\x0f\x00\x35\x00\x35\x00\x35\x00\xff\xff\xff\xff\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x07\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0c\x00\x72\x00\x00\x00\x11\x01\x35\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x01\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x2c\x00\x3a\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x0d\x00\xff\xff\x00\x00\x7d\x00\x35\x00\x35\x00\x35\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x3c\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x12\x00\x00\x00\x00\x00\x00\x00\x71\x00\x35\x00\x3d\x01\x1f\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x1e\x01\x18\x01\x19\x01\x3d\x01\x3d\x01\x3d\x01\x7c\x00\x10\x01\x3d\x01\x20\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x21\x01\x13\x01\x12\x01\x3d\x01\x14\x01\x3d\x01\x16\x01\x1c\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\xec\x00\x3d\x01\x3d\x01\xe8\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x1b\x01\x3d\x01\x3d\x01\x15\x01\x3d\x01\xe1\x00\x3d\x01\xc2\x00\xbc\x00\x3d\x01\x8e\x00\x3d\x01\x00\x01\x84\x00\x3d\x01\x3d\x01\x82\x00\xb8\x00\x3d\x01\xad\x00\xa1\x00\x3d\x01\x98\x00\x3d\x01\x3d\x01\xfa\x00\x3d\x01\x89\x00\x3d\x01\x3d\x01\x3d\x01\x38\x00\x17\x01\x1d\x01\x3d\x01\x35\x00\x35\x00\x35\x00\x7d\x00\x35\x00\x35\x00\x35\x00\x7f\x00\x35\x00\x35\x00\x35\x00\xff\xff\xff\xff\xff\xff\x36\x00\x36\x00\x36\x00\x36\x00\xff\xff\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\xff\xff\x35\x00\xff\xff\xff\xff\x00\x00\x35\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x00\x00\x00\x36\x00\x00\x00\x7b\x00\x3e\x00\x00\x00\x00\x00\x7b\x00\xff\xff\x10\x00\x10\x00\x10\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x4f\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x60\x00\xff\xff\x00\x00\x6c\x00\x00\x00\x00\x00\x41\x00\x00\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x00\x00\x16\x00\x00\x00\x00\x00\x00\x00\x08\x01\x00\x00\x1e\x00\x71\x00\x18\x00\x22\x00\xff\xff\x71\x00\x24\x00\x00\x00\x1a\x00\x71\x00\x00\x00\x00\x00\x00\x00\x20\x00\x0e\x00\x00\x00\x3b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x44\x00\x00\x00\x43\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x45\x00\xff\xff\x00\x00\x00\x00\x00\x00\x46\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x00\x00\x00\x00\x00\x00\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x00\xff\xff\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x47\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x55\x00\x54\x00\xff\xff\x00\x00\x56\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x58\x00\x00\x00\x59\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x5e\x00\x00\x00\x00\x00\x00\x00\x5d\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x61\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x62\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x63\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x64\x00\x66\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x5f\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x69\x00\xff\xff\x68\x00\x00\x00\x67\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x65\x00\x6a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x00\x00\x00\x00\x76\x00\x6e\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x78\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\xff\xff\x76\x00\x00\x00\x76\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x78\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\xff\xff\x76\x00\x00\x00\x76\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x78\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x00\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\x76\x00\xff\xff\x76\x00\x00\x00\x76\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x78\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\xff\xff\x77\x00\x00\x00\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x00\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x79\x00\x75\x00\x75\x00\x7a\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\xff\xff\x75\x00\x00\x00\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x75\x00\x75\x00\x75\x00\x00\x00\x75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x00\x77\x00\x75\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x77\x00\x00\x00\x77\x00\x3e\x01\x77\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x73\x00\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x1a\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x80\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x81\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd2\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb2\x00\x83\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x85\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x86\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x87\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x88\x00\x91\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x8a\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x8b\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x8c\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x8d\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf1\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x8f\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x90\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x92\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x93\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x94\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x95\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x06\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x96\x00\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x97\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x99\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9a\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9b\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9c\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9d\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9e\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x9f\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa0\x00\x3e\x01\x3e\x01\xa9\x00\x3e\x01\x3e\x01\x0d\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa2\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa3\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa5\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe5\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xa8\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xaa\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xab\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xac\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xae\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xaf\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb0\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb1\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb3\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb5\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd9\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xb9\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xba\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xbb\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xbd\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xbe\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xbf\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc0\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xcf\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc1\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc3\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc5\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc8\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xc9\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xca\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xcb\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xcc\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xcd\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xce\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd3\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd0\x00\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd1\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd5\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xd8\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xda\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xdb\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xdc\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xdd\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xde\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xdf\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe0\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe2\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe3\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\xf2\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xe9\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xea\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xeb\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xed\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xee\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xef\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf0\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf5\x00\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\xf3\x00\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\xf4\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf6\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf7\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf8\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xf9\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xfb\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xfc\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xfd\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xfe\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\xff\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x01\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x02\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x03\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x04\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x05\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x09\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x0a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x0b\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x0c\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3f\x01\x3e\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3e\x01\x3f\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3d\x01\x3e\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x01\x3e\x01\x3d\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x27\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x22\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3a\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3c\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3b\x01\x3e\x01\x3b\x01\x35\x01\x3e\x01\x23\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x24\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x35\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x25\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x26\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x36\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x2a\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x37\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x38\x01\x3e\x01\x38\x01\x40\x01\x3e\x01\x2c\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x39\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x2d\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2b\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x39\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3c\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3d\x01\x3e\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x28\x01\x29\x01\x29\x01\x29\x01\x29\x01\x29\x01\x29\x01\x29\x01\x29\x01\x29\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x41\x01\x3d\x01\x3d\x01\x42\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3e\x01\x3d\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x2e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x38\x01\x3e\x01\x38\x01\x40\x01\x3e\x01\x2f\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x2f\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x30\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x31\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3b\x01\x3e\x01\x3b\x01\x40\x01\x3e\x01\x32\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x32\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x33\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x34\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x40\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x3e\x01\x00\x00\x3e\x01\x3f\x01\x3e\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x40\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3d\x01\x3f\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x41\x01\x3d\x01\x3d\x01\x42\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x01\x3d\x01\x3d\x01\x3d\x01\x00\x00\x3d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3d\x01\x3f\x01\x3d\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x3f\x01\x00\x00\x3f\x01\x00\x00\x3f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

alex_check :: AlexAddr
alex_check = AlexA# "\xff\xff\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x62\x00\x65\x00\x67\x00\x69\x00\x6e\x00\x7b\x00\x63\x00\x6f\x00\x64\x00\x7d\x00\x65\x00\x0a\x00\x0a\x00\x0a\x00\x65\x00\x6e\x00\x64\x00\x63\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0b\x00\x0c\x00\x0d\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x20\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x7b\x00\x6f\x00\x20\x00\x64\x00\x7d\x00\x20\x00\x65\x00\x23\x00\x2d\x00\x20\x00\x2d\x00\x21\x00\x20\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0a\x00\x2d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x6f\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x2d\x00\xff\xff\x2e\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x2e\x00\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\xff\xff\x5c\x00\x23\x00\xff\xff\xff\xff\x5c\x00\xff\xff\xff\xff\x5c\x00\x20\x00\xff\xff\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x5c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x62\x00\xff\xff\xff\xff\xff\xff\x7b\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0a\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0a\x00\x0a\x00\x0a\x00\x20\x00\x0a\x00\x0a\x00\x0a\x00\x20\x00\x0a\x00\x0a\x00\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\xff\xff\x20\x00\xff\xff\x2d\x00\x23\x00\xff\xff\xff\xff\x2d\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\x43\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x20\x00\xff\xff\x4c\x00\xff\xff\xff\xff\x4f\x00\xff\xff\x2d\x00\xff\xff\xff\xff\xff\xff\x5c\x00\xff\xff\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\xff\xff\xff\xff\x67\x00\xff\xff\xff\xff\xff\xff\x74\x00\xff\xff\x63\x00\x7b\x00\x69\x00\x64\x00\x20\x00\x7b\x00\x65\x00\xff\xff\x6e\x00\x7b\x00\xff\xff\xff\xff\xff\xff\x6f\x00\x5c\x00\xff\xff\x7b\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x7b\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\x7d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x7d\x00\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x50\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\xff\xff\x49\x00\xff\xff\x54\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x4f\x00\x20\x00\xff\xff\xff\xff\xff\xff\x4e\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x53\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x49\x00\xff\xff\xff\xff\xff\xff\x55\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\xff\xff\x4c\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x20\x00\xff\xff\xff\xff\xff\xff\x54\x00\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\x4e\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x4f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4d\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x50\x00\x49\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\x45\x00\x4c\x00\x20\x00\xff\xff\x44\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\x44\x00\xff\xff\x41\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x54\x00\xff\xff\xff\xff\xff\xff\xff\xff\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x54\x00\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x50\x00\xff\xff\xff\xff\xff\xff\x59\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x45\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\x4d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x50\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\x4f\x00\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\x52\x00\x53\x00\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\x54\x00\xff\xff\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\x42\x00\x20\x00\x49\x00\xff\xff\x53\x00\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x45\x00\x4c\x00\x20\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x45\x00\xff\xff\xff\xff\x21\x00\x4e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x0a\x00\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x0a\x00\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x0a\x00\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x0a\x00\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x0a\x00\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x60\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x60\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\xff\xff\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5b\x00\x5c\x00\x5d\x00\x5e\x00\xff\xff\x60\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7c\x00\x21\x00\x7e\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\x2d\x00\xff\xff\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xff\xff\x3c\x00\x3d\x00\x3e\x00\x3f\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xff\xff\x7c\x00\xff\xff\x7e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

alex_deflt :: AlexAddr
alex_deflt = AlexA# "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x27\x00\xff\xff\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\x27\x00\xff\xff\xff\xff\x27\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\x6f\x00\xff\xff\xff\xff\x74\x00\x74\x00\x74\x00\x74\x00\x74\x00\x74\x00\x74\x00\x74\x00\x74\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

alex_accept = listArray (0::Int,322) [[],[(AlexAccPred  (alex_action_24) ( not' eof ))],[],[(AlexAcc (alex_action_27))],[],[(AlexAcc (alex_action_26))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40))],[],[(AlexAccPred  (alex_action_0) (alexRightContext 37))],[(AlexAccPred  (alex_action_0) (alexRightContext 37)),(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[(AlexAccPred  (alex_action_0) (alexRightContext 37))],[(AlexAccPred  (alex_action_0) (alexRightContext 37)),(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccSkip)],[(AlexAccPred  (alex_action_1) (alexRightContext 40)),(AlexAcc (alex_action_2))],[],[(AlexAccSkip)],[(AlexAccSkip)],[(AlexAccPred  (alex_action_4) ( inState code ))],[],[],[],[],[],[],[],[],[],[(AlexAccSkip)],[(AlexAccSkip)],[(AlexAcc (alex_action_7))],[(AlexAcc (alex_action_72))],[(AlexAccPred  (alex_action_19) ( not' (followedBy '#') ))],[(AlexAcc (alex_action_8))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_9))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_10))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_11))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_12))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_14))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_13))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_15))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_16))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_17))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAcc (alex_action_18))],[(AlexAccPred  (alex_action_19) ( not' (followedBy '#') ))],[],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof ))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof )),(AlexAcc (alex_action_78))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof ))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof )),(AlexAcc (alex_action_78))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof )),(AlexAcc (alex_action_78))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof )),(AlexAcc (alex_action_78))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof ))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof ))],[(AlexAccPred  (alex_action_20) ( keepComments .&&. (followedBy '\n' .||. eof) )),(AlexAccSkipPred  ( followedBy '\n' .||. eof ))],[],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_22))],[(AlexAccSkip)],[(AlexAccSkip)],[(AlexAcc (alex_action_28))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_29))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_30))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_31))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_32))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_33))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_34))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_35))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_36))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_37))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_38))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_39))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_40))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_41))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_42))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_43))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_44))],[(AlexAcc (alex_action_45))],[(AlexAcc (alex_action_46))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_47))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_48))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_49))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_50))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_51))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_52))],[(AlexAcc (alex_action_52))],[(AlexAcc (alex_action_52))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_53))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_54))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_55))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_56))],[],[(AlexAcc (alex_action_57))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_58))],[(AlexAcc (alex_action_59))],[(AlexAcc (alex_action_60))],[],[(AlexAcc (alex_action_61))],[(AlexAcc (alex_action_62))],[(AlexAcc (alex_action_63))],[(AlexAcc (alex_action_64))],[(AlexAcc (alex_action_65))],[(AlexAcc (alex_action_66))],[(AlexAcc (alex_action_67))],[(AlexAcc (alex_action_68))],[(AlexAcc (alex_action_69))],[(AlexAcc (alex_action_70))],[(AlexAcc (alex_action_71))],[(AlexAcc (alex_action_73))],[(AlexAcc (alex_action_74))],[(AlexAcc (alex_action_75))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_76))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[(AlexAcc (alex_action_77))],[],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[(AlexAcc (alex_action_78))],[],[],[]]
{-# LINE 187 "src/full/Agda/Syntax/Parser/Lexer.x" #-}


-- | This is the initial state for parsing a literate file. Code blocks
--   should be enclosed in @\\begin{code}@ @\\end{code}@ pairs.
literate :: LexState
literate = tex


-- | This is the initial state for parsing a regular, non-literate file.
normal :: LexState
normal = 0


{-| The layout state. Entered when we see a layout keyword ('withLayout') and
    exited either when seeing an open brace ('openBrace') or at the next token
    ('newLayoutContext').

    Update: we don't use braces for layout anymore.
-}
layout :: LexState
layout = layout_


{-| The state inside a pragma.
-}
pragma :: LexState
pragma = pragma_

{-| We enter this state from 'newLayoutContext' when the token following a
    layout keyword is to the left of (or at the same column as) the current
    layout context. Example:

    > data Empty : Set where
    > foo : Empty -> Nat

    Here the second line is not part of the @where@ clause since it is has the
    same indentation as the @data@ definition. What we have to do is insert an
    empty layout block @{}@ after the @where@. The only thing that can happen
    in this state is that 'emptyLayout' is executed, generating the closing
    brace. The open brace is generated when entering by 'newLayoutContext'.
-}
empty_layout :: LexState
empty_layout = empty_layout_


-- | This state is entered at the beginning of each line. You can't lex
--   anything in this state, and to exit you have to check the layout rule.
--   Done with 'offsideRule'.
bol :: LexState
bol = bol_


-- | This state can only be entered by the parser. In this state you can only
--   lex the keywords @using@, @hiding@, @renaming@ and @to@. Moreover they are
--   only keywords in this particular state. The lexer will never enter this
--   state by itself, that has to be done in the parser.
imp_dir :: LexState
imp_dir = imp_dir_


-- | Return the next token. This is the function used by Happy in the parser.
--
--   @lexer k = 'lexToken' >>= k@
lexer :: (Token -> Parser a) -> Parser a
lexer k = lexToken >>= k

-- | Do not use this function; it sets the 'ParseFlags' to
-- 'undefined'.
alexScan :: AlexInput -> Int -> AlexReturn (LexAction Token)

-- | This is the main lexing function generated by Alex.
alexScanUser :: ([LexState], ParseFlags) -> AlexInput -> Int -> AlexReturn (LexAction Token)



bol_,code,empty_layout_,imp_dir_,layout_,pragma_,tex :: Int
bol_ = 1
code = 2
empty_layout_ = 3
imp_dir_ = 4
layout_ = 5
pragma_ = 6
tex = 7
alex_action_0 =  end_ 
alex_action_1 =  withInterval TokTeX 
alex_action_2 =  withInterval TokTeX 
alex_action_4 =  begin_ tex 
alex_action_7 =  begin pragma 
alex_action_8 =  symbol SymOpenPragma 
alex_action_9 =  endWith $ symbol SymClosePragma 
alex_action_10 =  keyword KwOPTIONS 
alex_action_11 =  keyword KwBUILTIN 
alex_action_12 =  keyword KwCOMPILED_DATA 
alex_action_13 =  keyword KwCOMPILED_TYPE 
alex_action_14 =  keyword KwCOMPILED 
alex_action_15 =  keyword KwIMPORT 
alex_action_16 =  keyword KwIMPOSSIBLE 
alex_action_17 =  keyword KwLINE 
alex_action_18 =  withInterval $ TokString 
alex_action_19 =  nestedComment 
alex_action_20 =  withInterval TokComment 
alex_action_22 =  begin bol_ 
alex_action_24 =  offsideRule 
alex_action_26 =  endWith newLayoutContext 
alex_action_27 =  emptyLayout 
alex_action_28 =  keyword KwLet 
alex_action_29 =  keyword KwIn 
alex_action_30 =  keyword KwWhere 
alex_action_31 =  keyword KwField 
alex_action_32 =  keyword KwWith 
alex_action_33 =  keyword KwRewrite 
alex_action_34 =  keyword KwPostulate 
alex_action_35 =  keyword KwPrimitive 
alex_action_36 =  keyword KwOpen 
alex_action_37 =  keyword KwImport 
alex_action_38 =  keyword KwModule 
alex_action_39 =  keyword KwData 
alex_action_40 =  keyword KwCoData 
alex_action_41 =  keyword KwRecord 
alex_action_42 =  keyword KwConstructor 
alex_action_43 =  keyword KwInfix 
alex_action_44 =  keyword KwInfixL 
alex_action_45 =  keyword KwInfixR 
alex_action_46 =  keyword KwMutual 
alex_action_47 =  keyword KwAbstract 
alex_action_48 =  keyword KwPrivate 
alex_action_49 =  keyword KwSet 
alex_action_50 =  keyword KwProp 
alex_action_51 =  keyword KwForall 
alex_action_52 =  withInterval' (read . drop 3) TokSetN 
alex_action_53 =  keyword KwUsing 
alex_action_54 =  keyword KwHiding 
alex_action_55 =  keyword KwRenaming 
alex_action_56 =  endWith $ keyword KwTo 
alex_action_57 =  keyword KwPublic 
alex_action_58 =  hole 
alex_action_59 =  symbol SymEllipsis 
alex_action_60 =  symbol SymDot 
alex_action_61 =  symbol SymSemi 
alex_action_62 =  symbol SymColon 
alex_action_63 =  symbol SymEqual 
alex_action_64 =  symbol SymUnderscore 
alex_action_65 =  symbol SymQuestionMark 
alex_action_66 =  symbol SymBar 
alex_action_67 =  symbol SymOpenParen 
alex_action_68 =  symbol SymCloseParen 
alex_action_69 =  symbol SymArrow 
alex_action_70 =  symbol SymLambda 
alex_action_71 =  symbol SymAs 
alex_action_72 =  symbol SymOpenBrace 
alex_action_73 =  symbol SymCloseBrace 
alex_action_74 =  litChar 
alex_action_75 =  litString 
alex_action_76 =  literal LitInt 
alex_action_77 =  literal LitFloat 
alex_action_78 =  identifier 
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- -----------------------------------------------------------------------------
-- ALEX TEMPLATE
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.

-- -----------------------------------------------------------------------------
-- INTERNALS and main scanner engine

{-# LINE 35 "templates/GenericTemplate.hs" #-}

{-# LINE 45 "templates/GenericTemplate.hs" #-}


data AlexAddr = AlexA# Addr#

#if __GLASGOW_HASKELL__ < 503
uncheckedShiftL# = shiftL#
#endif

{-# INLINE alexIndexInt16OffAddr #-}
alexIndexInt16OffAddr (AlexA# arr) off =
#ifdef WORDS_BIGENDIAN
  narrow16Int# i
  where
	i    = word2Int# ((high `uncheckedShiftL#` 8#) `or#` low)
	high = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
	low  = int2Word# (ord# (indexCharOffAddr# arr off'))
	off' = off *# 2#
#else
  indexInt16OffAddr# arr off
#endif





{-# INLINE alexIndexInt32OffAddr #-}
alexIndexInt32OffAddr (AlexA# arr) off = 
#ifdef WORDS_BIGENDIAN
  narrow32Int# i
  where
   i    = word2Int# ((b3 `uncheckedShiftL#` 24#) `or#`
		     (b2 `uncheckedShiftL#` 16#) `or#`
		     (b1 `uncheckedShiftL#` 8#) `or#` b0)
   b3   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 3#)))
   b2   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 2#)))
   b1   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
   b0   = int2Word# (ord# (indexCharOffAddr# arr off'))
   off' = off *# 4#
#else
  indexInt32OffAddr# arr off
#endif





#if __GLASGOW_HASKELL__ < 503
quickIndex arr i = arr ! i
#else
-- GHC >= 503, unsafeAt is available from Data.Array.Base.
quickIndex = unsafeAt
#endif




-- -----------------------------------------------------------------------------
-- Main lexing routines

data AlexReturn a
  = AlexEOF
  | AlexError  !AlexInput
  | AlexSkip   !AlexInput !Int
  | AlexToken  !AlexInput !Int a

-- alexScan :: AlexInput -> StartCode -> AlexReturn a
alexScan input (I# (sc))
  = alexScanUser undefined input (I# (sc))

alexScanUser user input (I# (sc))
  = case alex_scan_tkn user input 0# input sc AlexNone of
	(AlexNone, input') ->
		case alexGetChar input of
			Nothing -> 



				   AlexEOF
			Just _ ->



				   AlexError input'

	(AlexLastSkip input len, _) ->



		AlexSkip input len

	(AlexLastAcc k input len, _) ->



		AlexToken input len k


-- Push the input through the DFA, remembering the most recent accepting
-- state it encountered.

alex_scan_tkn user orig_input len input s last_acc =
  input `seq` -- strict in the input
  let 
	new_acc = check_accs (alex_accept `quickIndex` (I# (s)))
  in
  new_acc `seq`
  case alexGetChar input of
     Nothing -> (new_acc, input)
     Just (c, new_input) -> 



	let
		base   = alexIndexInt32OffAddr alex_base s
		(I# (ord_c)) = ord c
		offset = (base +# ord_c)
		check  = alexIndexInt16OffAddr alex_check offset
		
		new_s = if (offset >=# 0#) && (check ==# ord_c)
			  then alexIndexInt16OffAddr alex_table offset
			  else alexIndexInt16OffAddr alex_deflt s
	in
	case new_s of 
	    -1# -> (new_acc, input)
		-- on an error, we want to keep the input *before* the
		-- character that failed, not after.
    	    _ -> alex_scan_tkn user orig_input (len +# 1#) 
			new_input new_s new_acc

  where
	check_accs [] = last_acc
	check_accs (AlexAcc a : _) = AlexLastAcc a input (I# (len))
	check_accs (AlexAccSkip : _)  = AlexLastSkip  input (I# (len))
	check_accs (AlexAccPred a pred : rest)
	   | pred user orig_input (I# (len)) input
	   = AlexLastAcc a input (I# (len))
	check_accs (AlexAccSkipPred pred : rest)
	   | pred user orig_input (I# (len)) input
	   = AlexLastSkip input (I# (len))
	check_accs (_ : rest) = check_accs rest

data AlexLastAcc a
  = AlexNone
  | AlexLastAcc a !AlexInput !Int
  | AlexLastSkip  !AlexInput !Int

data AlexAcc a user
  = AlexAcc a
  | AlexAccSkip
  | AlexAccPred a (AlexAccPred user)
  | AlexAccSkipPred (AlexAccPred user)

type AlexAccPred user = user -> AlexInput -> Int -> AlexInput -> Bool

-- -----------------------------------------------------------------------------
-- Predicates on a rule

alexAndPred p1 p2 user in1 len in2
  = p1 user in1 len in2 && p2 user in1 len in2

--alexPrevCharIsPred :: Char -> AlexAccPred _ 
alexPrevCharIs c _ input _ _ = c == alexInputPrevChar input

--alexPrevCharIsOneOfPred :: Array Char Bool -> AlexAccPred _ 
alexPrevCharIsOneOf arr _ input _ _ = arr ! alexInputPrevChar input

--alexRightContext :: Int -> AlexAccPred _
alexRightContext (I# (sc)) user _ _ input = 
     case alex_scan_tkn user input 0# input sc AlexNone of
	  (AlexNone, _) -> False
	  _ -> True
	-- TODO: there's no need to find the longest
	-- match when checking the right context, just
	-- the first match will do.

-- used by wrappers
iUnbox (I# (i)) = i
