#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2021, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org )

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import logging; logger = logging.getLogger(__name__); logger.info("import")

#Standard Library

#Third Party
from PyQt5 import QtCore, QtGui, QtWidgets


class WaitThread(QtCore.QThread):
    def __init__(self, mainWindow, longRunningFunction):
        self.longRunningFunction = longRunningFunction
        self.mainWindow = mainWindow
        self.finished = False
        QtCore.QThread.__init__(self)

    def __del__(self):
        """This gets called rather early in the objects life but is in the main thread!"""
        self.wait()
        #This is after run
        self.finished = True
        logger.info(f"Thread done {self.longRunningFunction}")

    def run(self):
        """This is in the side-thread. We can't access qt widgets here"""
        logger.info(f"Thread running {self.longRunningFunction}")
        self.longRunningFunction()
        self.finished = True

class WaitDialog(object):
    """An information text that closes itself once a task is done.
    Executes and shows on construction"""

    def __init__(self, mainWindow, text, longRunningFunction):

        super().__init__()
        self.text = text
        logger.info(f"Starting blocking message for {longRunningFunction}")
        self.mainWindow = mainWindow
        self.mainWindow.ui.messageLabel.setText(text)
        #self.mainWindow.ui.messageLabel.setWordWrap(True)  #qt segfault! maybe something with threads... don't care. We truncate now, see below.
        self.mainWindow.ui.mainPageSwitcher.setCurrentIndex(1) #1 is messageLabel 0 is the tab widget
        self.mainWindow.ui.menubar.setEnabled(False) #TODO: this will leave the options in the TrayIcon menu available.. but well, who cares...

        def wrap():
            longRunningFunction(self.progressInfo)

        wt = WaitThread(mainWindow, wrap)
        #wt.finished.connect(self.threadDone) #does NOT trigger
        wt.start()
        while not wt.finished:
            self.mainWindow.qtApp.processEvents()

        self.mainWindow.ui.menubar.setEnabled(True)
        self.mainWindow.ui.mainPageSwitcher.setCurrentIndex(0) #1 is messageLabel 0 is the tab widget


    def progressInfo(self, path:str):
        #paths can be very long. They will destroy our complete layout if unchecked. we truncate to -80
        self.mainWindow.ui.messageLabel.setText(self.text + "\n\n" + path[-80:])

