// ClientSocket.cpp : implementation file
//

#include "stdafx.h"
#include "aime_w32.h"
#include "ClientSocket.h"
#include "mudtypes.h"
#include "strings.h"
#include "newfuncts.h"
#include "global.h"
#include "sysdep.h"
#include "utils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClientSocket

CClientSocket::CClientSocket()
{
	valid_input = FALSE;
	locked = FALSE;
}

CClientSocket::~CClientSocket()
{
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CClientSocket, CSocket)
	//{{AFX_MSG_MAP(CClientSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CClientSocket member functions

void CClientSocket::OnConnect(int nErrorCode)
{
	AfxMessageBox("Connection complete");
}


void CClientSocket::OnReceive(int nErrorCode)
{
   char input_buffer[MAX_COM_LEN+4];
   int  holder_count = 0;
   BOOL the_end = FALSE;

   // We need to avoid letting two connection-accessing cycles run concurrently so while this
   // is locked, we sleep it off
   while (set_locked() == FALSE)
		Sleep(10);

   for (int x=0; x<the_config.maxreadsperpoll; x++)
   {
		BZERO(input_buffer,MAX_COM_LEN+3);

		the_end = FALSE;
		if (Receive(input_buffer, MAX_COM_LEN - 1) == SOCKET_ERROR)
		{
			if (GetLastError() == WSAEMSGSIZE)
				the_end = FALSE;
			else
				the_end = TRUE;
		}
		else
		{
			the_end = TRUE;
		}

        if (*input_buffer != '\0')
        {
           if (fill_read_buffer(input_buffer) < 0)
		   {
			  unlock();
              return;
		   }
		}

		if (the_end == TRUE)
			break;

   } // main for
   valid_input = TRUE;

   unlock();
   if (read_buffer.get_first() == NULL)
      return;

   return;
}


/***********************************************************************
 ** set_locked - locks this socket.  If it has already been locked,
 **              returns FALSE, otherwise returns TRUE
 ***********************************************************************/

BOOL CClientSocket::set_locked()
{
	if (locked)
		return FALSE;

	locked = TRUE;
	return TRUE;
}


/***********************************************************************
 ** unlock - unlocks the socket so it is free for use
 ***********************************************************************/

void CClientSocket::unlock()
{
	locked = FALSE;
}


/***********************************************************************
 ** fill_read_buffer - fills up the read buffer with any input in the socket
 **
 ** Parameters: the_conn - the connection to check for
 **
 ** Returns: 1 for has it, 0 if not found
 **
 ***********************************************************************/

int CClientSocket::fill_read_buffer(char *input_buf)
{
  char copy_buffer[MAX_COM_LEN+4];
  char *str_ptr = input_buf;
  char *new_ptr = NULL;
  int  counter = 0;
  Strings *new_str = NULL;

  /* remove all wierd telnet function chars */
#ifdef DEBUG_INPUT
  printf("Packet: %s\n", str_ptr);
  printf("Strlen: %d\n", strlen(str_ptr));
#endif

  // Read the input buffer until we hit the end of it
  while ((str_ptr) && (*str_ptr != '\0'))
  {
    // Set up a buffer to write valid chars to
    BZERO(copy_buffer, MAX_COM_LEN+4);
    new_ptr = copy_buffer;

    // Now search along the input for the length of the line
    while ((str_ptr) && (*str_ptr != '\n') && (*str_ptr != '\0'))
    {
      // Skip this char if it is not an authorized char
      if ( ((((int) (*str_ptr)) < 32) || (((int) (*str_ptr)) > 126)) &&
		  (*str_ptr != '\b'))
		str_ptr++;

      // Else, it is an authorized char, copy it
      else
      {
		*new_ptr = *str_ptr;
		new_ptr++;
		str_ptr++;
      }
    }

    // Now we theoretically have the entire line, if the length is greater
    // than zero, lets copy it to a buffer.  If it is just a newline, they simply
	// hit enter but we still want to register that
    if ((strlen(copy_buffer) > 0) || (*str_ptr == '\n'))
    {
      // If we don't have a newline, add this to the partial buffer
      if (*str_ptr != '\n')
      {
		 partial_line.str_cat(copy_buffer);
      }
      else
      {
		 new_str = new Strings(partial_line.str_show());
		 new_str->str_cat(copy_buffer);
		 partial_line.truncate(0);
		 new_str->remove_newline();
		 read_buffer.add_tail_entry(new_str);
		 counter++;
      }
    }

    if ((str_ptr) && (*str_ptr != '\0'))
      str_ptr++;
  }
  return counter;
}
