#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# Stuff shared by all albatross modules

# Base exception class used by all Albatross exceptions
class AlbatrossError(Exception):
    pass


# Generic causes of exceptions:
class UserError(AlbatrossError):
    pass


class ApplicationError(AlbatrossError):
    pass


class InternalError(AlbatrossError):
    pass


class ServerError(AlbatrossError):
    pass


# Specific exceptions:
class SecurityError(UserError):
    pass


class TemplateLoadError(ApplicationError):
    pass
