#!/usr/bin/python
import os
from albatross import SimpleContext, TemplateLoadError

script_name = os.environ['SCRIPT_NAME']
request_uri = os.environ['REQUEST_URI']
page = request_uri[len(script_name) + 1:]
if not page:
    page = 'main.html'

ctx = SimpleContext('templ')
ctx.load_template('macros.html').to_html(ctx)
ctx.locals.page = page
try:
    templ = ctx.load_template(page)
except TemplateLoadError:
    templ = ctx.load_template('oops.html')

templ.to_html(ctx)

print 'Content-Type: text/html'
print
ctx.flush_content()
