#!/usr/bin/python
from albatross.cgiapp import Request
from albatross import SimpleSessionApp

node_num = 0


class Node:

    def __init__(self, name, children = None):
        self.name = name
        if children is not None:
            self.children = children
        self.selected = 0
        global node_num
        self.node_num = node_num
        node_num = node_num + 1

    def albatross_alias(self):
        return 'node%d' % self.node_num


class TreePage:

    def page_enter(self, ctx):
        ctx.locals.tree \
            = Node('a', [Node('a', [Node('a'),
                                    Node('b')]),
                         Node('b', [Node('a', [Node('a', [Node('a'),
                                                          Node('b')])]),
                                    Node('b'),
                                    Node('c', [Node('a'),
                                               Node('b')])])])
        ctx.add_session_vars('tree')

    def page_display(self, ctx):
        ctx.run_template('tree.html')


app = SimpleSessionApp('tree.py', '.', 'start', 'tree', '-=-secret-=-')
app.register_page('start', TreePage())


if __name__ == '__main__':
    app.run(Request())
