#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
#
# Dummy Request objects
#
# $Id: request.py,v 1.5 2003/01/27 10:23:27 djc Exp $
#

import string, re

class DummyCookieRequest:
    """
    A dummy Request-like class that serves to record the user's session id
    """
    def __init__(self):
        self.cookie = None

    def write_header(self, hdr, value):
        if hdr == 'Set-Cookie':
            self.cookie = value

    def get_header(self, hdr):
        if hdr == 'Cookie':
            return self.cookie

    def end_headers(self):
        pass

class DummyFieldRequest:
    def __init__(self):
        self.fieldre = re.compile(r'<input type="hidden" name="(__al[a-zA-Z0-9]*__)" value="([^"]*)">', re.I|re.M|re.S)
        self.fields = {}
        self.__content_parts = []

    def has_field(self, field):
        return self.fields.has_key(field)

    def field_value(self, field):
        return self.fields[field]

    def write_content(self, data):
        self.__content_parts.append(data)

    def flush_content(self):
        data = string.join(self.__content_parts, '')
        match = self.fieldre.search(data)
        if match:
            key = match.group(1)
            value = match.group(2)
            self.fields[key] = value


