//==============================================
//  copyright            : (C) 2003-2004 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

//Systemwide includes
#include <qlayout.h>
#include <qlabel.h>
#include <qfont.h>

//Projectwide includes
#include "themesWidget.h"

//==============================================
ThemesWidget::ThemesWidget( QWidget* parent,
              const char* name ) : QWidget( parent, name)
{
  categoryLabel = new QLabel( tr("Theme Settings"), this);
  QFont labelFont = categoryLabel->font();
  labelFont.setWeight(QFont::Bold);
  categoryLabel->setFont( labelFont );

  horizontalLine = new QFrame(this);
  horizontalLine->setLineWidth(2);
  horizontalLine->setMidLineWidth(1);
  horizontalLine->setFrameStyle( QFrame::HLine | QFrame::Raised );
  
  grid = new QGridLayout( this, 7, 1, 0);
  grid->addWidget( categoryLabel,  0, 0, Qt::AlignLeft );
  grid->setRowSpacing(1, 8);
  grid->addWidget( horizontalLine,  2, 0 );
  grid->setRowSpacing(3, 8);
  grid->setRowStretch( 6, 1 ); 
}
//==============================================
