//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef GUI_EDITING_PANNINGPREVIEWINTERFACE_H
#define GUI_EDITING_PANNINGPREVIEWINTERFACE_H

#include <qrect.h>

#include "splitViewInterface.h"

//=====================================
/*! \brief */
//=====================================
class PanningPreviewInterface : public SplitViewInterface
{
Q_OBJECT

public:
  ///Creates layout
  PanningPreviewInterface(QString imageFilename, QWidget *parent=0, const char* name=0);

  virtual QSize sizeHint() const;

  //get current selection
  QRect getSelection();

  //returns size of space that will be used for painting
  QSize paintingSize();

  //----------------------
protected:
  void resizeEvent( QResizeEvent * );
  //----------------------
private:
  //util funtion - generates orig image and signals adjusted image is out of date
  void generateOrigImage();
  
  ///Full size image
  QImage fullSizeImage;

  ///Current selection
  QRect selection;
  //----------------------
signals:
  //emitted when the selected region has changed indicating the adjusted image is out of date
  void selectionChanged();
  //----------------------
public slots:
  //reset selected region
  void setSelection( QRect selection );
  //----------------------
};
//======================

#endif //GUI_EDITING_PANNINGPREVIEWINTERFACE_H
