//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "proTools.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString ProTools::filename()
{
  return QString("%1/proTools.html").arg(TEMP_DIR);
}
//==============================================
void ProTools::generateHTML(QTextStream::Encoding type, QString charSet)
{
  QString ctrlKey;
#if defined(Q_OS_MACX)
  ctrlKey = "Command";
#else
  ctrlKey = "Ctrl";
#endif

  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Pro Tools") << "</font></td>\n";
    stream << "</tr></table>\n";
    stream << "<font face='Arial, sans-serif'>\n";
    
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Histogram Editing, Brightness, and Contrast:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Sometimes the quick-fix techniques just don't work. Noisy or grainy images are often the culprits.") << "\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper provides an advanced levels editor for fixing the color and luminosity ranges, in addition to changing overall photo brightness and contrast. Red, green, blue, and luminosity ranges can be adjusted by dragging their boundaries or selecting a new range. Brightness and contrast changes can be undone independently by clicking the respective icons below each slider.") << "\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper's novel split-view interface lets you compare the modified image to the original side by side in real time. You can even drag this split back and forth.") << "\n";
    stream << "<p align='justify'>\n";
    stream << QString(HelpWindow::tr("If you prefer to look at just the adjusted or original image form, change the view mode with the drop down menu below the image. You can also switch between the two versions of the image instantly by pressing and holding the %1 key.")).arg(ctrlKey) << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/levelsEditor.png'>\n";
    stream << "</td></tr></table>\n";
              
    stream << "</td></tr><tr><td>\n";
              
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Grain Enhancement:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
              
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/grainEditor.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper provides a grain editor that can blur and sharpen images without magnifying image noise. Drag the slider up to sharpen or down to blur. You can change which portion of the image is being shown up close by dragging around the view control area at the right.") << "\n";
    stream << "</td></tr></table>\n";
                
    stream << "</font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
