//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_RECENTALBUMMENUITEM_H
#define GUI_RECENTALBUMMENUITEM_H

#include <qmenudata.h> 
#include <qimage.h>

//forward declarations

//=====================================
/*! \brief A custom menu entry, displays album image, name, and number of photos
 */
//=====================================
class RecentAlbumMenuItem : public QCustomMenuItem
{
//----------------------
public:
  RecentAlbumMenuItem( Key acceleratorKey );

  ///updates entry as per arguments passed (used by constructor during intiailization as well)
  void changeItem( QString albumName, QString albumLocation, QString numPhotos );
    
  
  ///paints entry
  void paint( QPainter * p, const QColorGroup & cg, bool act, bool enabled, 
              int x, int y, int w, int h );

  ///returns menu entry size
  QSize sizeHint ();

  ///after all menu items have been refreshed hint at maximum width so we
  ///can adequately position the accelerator text 
  void setMaxWidth( int val );

  ///no icon necessary since album image painted here
  bool fullSpan() const;
  //----------------------
private:
  Key acceleratorKey;

  ///album image
  QImage albumImage;
  
  ///album name
  QString albumName;
  
  ///number of photos
  QString numPhotos;
  
  ///computed size
  QSize size;  

  ///max element width
  int maxWidth;

  ///used for painting purposes
  int idealImageWidth;
  //----------------------
};
//======================
#endif //GUI_RECENTALBUMMENUITEM_H
