# This Alicq module used to save positions of newly opened wnidows and open
# then with saved geometry on creation

# Author: Ihar Viarheichyk <iverg@mail.ru>

package require Tk
variable file geometry

# Make all toplevel windows accept 'geometry' option
rename ::toplevel ::toplevel.orig
proc ::toplevel {win args} {
	eval [list ::toplevel.orig $win] $args
	set gm [option get $win geometry Geometry]
	if {$gm!=""} { wm geometry $win $gm }
	set win
}

# Save geometry information if it was changed
proc SaveWin {win} {
	variable file
	variable cache
	set gm [wm geometry $win]
	if {![info exists cache($win)] || $cache($win)!=$gm} {
		set cache($win) $gm
		set win [string range $win 1 end]
		if {$win==""} {set win [winfo class .]}
		option add *$win.geometry $gm 
		after idle [list Save $file "\\\*${win}\\\.geometry:" "*$win.geometry: $gm"]
	}
}

proc bindclasses {list} {
	foreach class $list { bind $class <Destroy> [nc SaveWin %W] }
}

# Save proporting between incoming and outgoing messages panes
bind MsgFrame <Destroy> +[namespace code {
	set win [string range %W 1 end]
	after idle [list Save $file "\\\*${win}\\\.height:" "*${win}.height: [winfo height %W]"]
}]

# Read geometry information from file, if exists. If file has wrong format,
# it is overwriten with suffix .bad
if [file exists $file] {
	if {[catch { option readfile $file startupFile }]} {
		file rename -force $file ${file}.bad
	}
}

# Specify window classes wich require saving geometry info
bindclasses {AlicqUserWindow AlicqContactsWindow AlicqAuthRequestWindow \
	AlicqAskAuthWindow AlicqURLWindow AlicqSMSWindow\
	AlicqHistoryWindow AlicqInfoWindow}
			 
after idle [namespace code {bindclasses [winfo class .]}]
