# This module is used to create and update WidowMaker dock icon
# It is a part of Alicq instant messenger client
#
# Author: Ihar Viarheichyk

option add *iconFont -*-fixed-medium-r-normal--10-* widgetDefault

proc MonitorStatus {args} {
	variable status
	.icon.c itemconfigure text -text [mc $status]
	.icon.c itemconfigure icon -image img:$status
}

proc ShowHide {} {
	wm state . [expr ([string equal [wm state .] normal])?"withdrawn":"normal"]
}

proc GetMessages {} {
	set lst [select Contact {[info exists Pending]}]
	if {[llength $lst]} {
		set uid [lindex $lst 0]
		Event $uid|Send:text $uid|Send:text
	}
}

proc CreateIcon {} {
	if {[wm iconwindow .]==""} {
		toplevel .icon -class AlicqIcon
		wm iconwindow . .icon
	}
	canvas .icon.c -background black -width 52 -height 52 -relief sunken
	.icon.c create image 26 26 -anchor s -tag icon
	.icon.c create text 26 52 -anchor s -fill white -tag text
	set font [option get . iconFont Font]
	if {$font!=""} { .icon.c itemconfigure text -font $font }

	pack .icon.c
	bind .icon.c <1> {.main.m unpost}
	.icon.c bind icon <1> [nc GetMessages]
	.icon.c bind icon <3> {.status.m post %X %Y}
	.icon.c bind text <1> [nc ShowHide]
	.icon.c bind text <3> {.main.m post %X %Y}
	MonitorStatus
}

handler Flashing Flasher {stage} {
	variable status
	.icon.c itemconfigure icon -image img:[expr {$stage?$status:"message"}]
}

# Bind ICQ status to local status variable
upvar #0 [ref Me](Status) status
trace variable status w [nc MonitorStatus]

# Hide window instead of deletion
wm protocol . WM_DELETE_WINDOW {wm withdraw .}
resource icons {away dnd ffc group invisible message na occ offline online url}

CreateIcon

