# This package provides often used helper function to make code more elegant
#
# Author: Ihar Viarheichyk 
package provide helper 1.0

# Functional programming stuff
proc map {x list cmd} {
	set result [list]
	upvar 1 $x item
	foreach item $list { lappend result [uplevel 1 $cmd] }
	set result
}

proc grep {x list cmd} {
	set result [list]
	upvar 1 $x item
	foreach item $list { 
		if {[uplevel 1 expr "{$cmd}"]} {lappend result $item}
	}
	set result
}

# Delete items from list by value
proc ldelete {listvar items} {
	upvar 1 $listvar lst
	foreach item $items {
		if {[set pos [lsearch $lst $item]]!=-1} {
			set lst [lreplace $lst $pos $pos]	
		}
	}
}

proc lcompare {old new} {
	foreach {comm innew inold} [list {} {} {}] break
	foreach n $new {
		if {[lsearch $old $n]==-1}\
			{lappend innew $n} else {lappend comm $n}
	}
	foreach n $old {
		if {[lsearch $new $n]==-1}\
			{lappend inold $n} else {lappend comm $n}
	}
	list $comm $innew $inold
}

# Detect if one of the programs exists in a path
proc External {list} {
	set path [split $::env(PATH) :]
	foreach x $list {
		foreach dir $path {
			if {[file executable [file join $dir $x]]} { return $x }
		}
	}
	return ""
}

#proc delayed {proc args} { foreach x {cancel idle} {after $x $proc $args} }
proc delayed {args} { foreach x {cancel idle} {after $x $args} }
proc nc {args} { uplevel 1 [list namespace code $args] }
proc vars {args} { foreach x $args {uplevel 1 variable $x}}

