
var initialised = false;

var fx_mainWindow, fx_browser, fx_sidebar, fx_sidebarBox, fx_sidebarHeader, fx_sidebarSplitter, fx_sidebarMenu, fx_maximizedWindow;
var aios_toggleBox, aios_toggleBar, aios_toggleSwitchItem, aios_toggleToolbarItem, aios_toolbar;
var elem_switch, elem_tbb, elem_key, elem_close, elem_close2;


// Sidebar nur zusammenklappen statt schließen
var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
if(aios_collapseSidebar && aios_allowCollapseSidebar()) {
    var aios_collapsingSidebar = true;
    aios_enableCollapsingSidebar();
}


function aios_getObjects() {
    try {
        fx_mainWindow = document.getElementById('main-window');
        fx_browser = document.getElementById('browser');
        fx_sidebar = document.getElementById('sidebar');
        fx_sidebarBox = document.getElementById('sidebar-box');
        fx_sidebarHeader = document.getElementById('sidebarheader');
        fx_sidebarSplitter = document.getElementById('sidebar-splitter');
        fx_sidebarMenu = document.getElementById('viewSidebarMenu');

        aios_toggleBox = document.getElementById('aios-toggle-toolbox');
        aios_toggleBar = document.getElementById('aios-toggle-toolbar');

        // broadcaster in aios.xul mit gespeichertem Wunsch-Toolbar-Zustand
        // 	=> gespeichert durch onViewToolbarCommand() in tbx.js (AiOS < 0.7.7)
        // 	=> gespeichert/gesetzt durch aios_toggleToolbar()
        aios_toggleSwitchItem = document.getElementById('aios-viewTogglebar');
        aios_toggleToolbarItem = document.getElementById('aios-viewToolbar');

        aios_toolbar = document.getElementById('aios-toolbar');

        elem_switch = document.getElementById('aios-toggle-button');
        elem_tbb = document.getElementById('sidebars-togglebutton');
        elem_key = document.getElementById('aiosKey_sidebar');
        elem_close = document.getElementById('sidebarclose-button');
        elem_close2 = document.getElementById('sbh-sidebarclose-button');
    }
    catch(e) { }
}


// Sidebar-Ladezustand überwachen
/*
var aiosSBListener = {
	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
				aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
				aIID.equals(Components.interfaces.nsISupports))
			return this;
			throw Components.results.NS_NOINTERFACE;
		},

	onStateChange: function(aProgress, aRequest, aFlag, aStatus) {

		if(document.getElementById('aiosLoader')) {
			if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_STOP) {
	  		document.getElementById('aiosLoader').setAttribute('hidden', true);
			}

			if(aFlag & Components.interfaces.nsIWebProgressListener.STATE_START) {
				document.getElementById('aiosLoader').setAttribute('hidden', false);
			}
		}

		return 0;
	},

	onProgressChange: function(webProgress, request, curSelfProgress, maxSelfProgress, curTotalProgress, maxTotalProgress) {
		return 0;
	},
	onLocationChange: function(aProgress, aRequest, aURI) { return 0; },
	onStatusChange: function(aProgress, aRequest, aStatus, aMessage ) { return 0; },
	onSecurityChange: function() { return 0; },
	onLinkIconAvailable: function() { return 0; }
};
*/


/*
	Initialisierung
		=> Aufruf durch das onload-Event in aios.xul
*/
function aios_initSidebar() {
    aios_getObjects();

    // CSS-Stylesheets entsprechend des Themes und des OS hinzufügen
    if(aios_appDefTheme) aios_addCSS("aios_theme_default.css", "main-window");
    if(aios_appDefTheme && aios_appOS == "WINNT") aios_addCSS("aios_theme_winnt.css", "main-window");
    if(aios_appDefTheme && aios_appOS == "Linux") aios_addCSS("aios_theme_linux.css", "main-window");
    if(aios_appDefTheme && aios_appOS == "Darwin") aios_addCSS("aios_theme_darwin.css", "main-window");

    // MacOS X => Tastaturkürzel ersetzen (Strg. wird durch Command ersetzt und Umschalt durch das Symbol dafür)
    if(aios_appOS == "Darwin") {
        aios_replaceKey('switch-tooltip-box', 'r2c2', 'command');
        aios_replaceKey('template-sidebar-tooltip-box', 'r2c2', 'command');
        aios_replaceKey('template-window-tooltip-box', 'r2c2', 'command');
        aios_replaceKey('paneltab-tooltip-box', 'r2c2', 'command');
        aios_replaceKey('paneltab-tooltip-reverse-box', 'r2c2', 'command');
        aios_replaceKey('sidebarheader-tooltip-box', 'r3c2', 'command');

        aios_replaceKey('switch-tooltip-box', 'r3c2', 'shift');
        aios_replaceKey('template-sidebar-tooltip-box', 'r3c2', 'shift');
        aios_replaceKey('template-window-tooltip-box', 'r3c2', 'shift');
        aios_replaceKey('paneltab-tooltip-box', 'r3c2', 'shift');
        aios_replaceKey('paneltab-tooltip-reverse-box', 'r3c2', 'shift');
        aios_replaceKey('sidebarheader-tooltip-box', 'r1c2', 'shift');
    }

    // für CSS-Zwecke speichern
    fx_mainWindow.setAttribute('aios_appVendor', aios_appVendor);
    fx_mainWindow.setAttribute('aios_appVersion', aios_appVersion);
    fx_mainWindow.setAttribute('aios_appOS', aios_appOS);
    fx_mainWindow.setAttribute('aios_appDefTheme', aios_appDefTheme);

    /* Daten der Toolbar-Funktionalität < 0.7.7 loeschen bzw. zuruecksetzen */
    if(fx_mainWindow.getAttribute('aiosFxV')) {
        fx_mainWindow.removeAttribute('aiosFxV');
        document.persist(fx_mainWindow.id, 'aiosFxV');
    }

    if(fx_mainWindow.getAttribute('_toolbar_currentset_aiostbx-toolbar-tableft')) {
        fx_mainWindow.removeAttribute('_toolbar_currentset_aiostbx-toolbar-tableft');
        document.persist(fx_mainWindow.id, '_toolbar_currentset_aiostbx-toolbar-tableft');
    }

    if(fx_mainWindow.getAttribute('_toolbar_currentset_aiostbx-toolbar-tabright')) {
        fx_mainWindow.removeAttribute('_toolbar_currentset_aiostbx-toolbar-tabright');
        document.persist(fx_mainWindow.id, '_toolbar_currentset_aiostbx-toolbar-tabright');
    }

    if(document.getElementById('aiostbx-toolbar-statusbar-right').getAttribute('currentset')) {
        document.getElementById('aiostbx-toolbar-statusbar-right').removeAttribute('currentset');
        document.persist('aiostbx-toolbar-statusbar-right', 'currentset');
    }

    if(document.getElementById('aiostbx-toolbar-statusbar-left').getAttribute('currentset')) {
        document.getElementById('aiostbx-toolbar-statusbar-left').removeAttribute('currentset');
        document.persist('aiostbx-toolbar-statusbar-left', 'currentset');
    }
    /* Ende Daten loeschen */

    // Positionierung der Toolbox (hier durch den Aufruf von aios_setSidebarOrient() nicht mehr noetig)
    //aios_setToolbarPos();

    // Sidebar li. oder re.
    // Eigenschaftenzuweisung für CSS (LTR <=> RTL; Sidebar links <=> rechts)
    aios_setSidebarOrient();

    // beim ersten Start (bzw. nach löschen der localstore.rdf) => ...
    if(!aios_getBoolean(fx_sidebarBox, 'aiosInit')) {
        // Icongröße an die der Nav-Toolbar anpassen
        fx_sidebarBox.setAttribute('aiosInit', true);
        document.persist(fx_sidebarBox.id, 'aiosInit');

        if(aios_toolbar) aios_toolbar.setAttribute('iconsize', document.getElementById('nav-bar').getAttribute('iconsize'));

        // Sidebar-Breite nach Konfiguration festsetzen
        aios_setConfSidebarWidth();
    }


    // Sidebarheader-Symbolleiste aus der Navigations-Symbolleiste in den Sidebarheader verschieben
    // wenn die Symbolleiste gleich im Header wäre, würden keine Icons angezeigt werden, wenn die Sidebar beim Start geschlossen ist
    document.getElementById('aios-sbhtoolbox').appendChild(document.getElementById('aios-sbhtoolbar'));


    // legt commands (Ziele) für Manager und Fenster lt. Einstellungen fest
    window.setTimeout("aios_setTargets()", 50);

    // modifiziert alle Sidebar-Tastenkombinationen
    aios_modKeys();

    // Autohide-Feature initialisieren
    aios_initAutohide();


    // Sidebar nur zusammenklappen statt schließen
    var lp;
    var aios_collapseSidebar = aios_gPrefBranch.getBoolPref('collapse');
    if(aios_collapseSidebar && aios_allowCollapseSidebar()) {

        /*
			der Aufruf von aios_enableCollapsingSidebar() wäre hier zeitlich (onLoad) zu spät,
			da Original-Funktionen zur Laufzeit geändert werden müssen

			die anderen folgenden Anpassungen kšnnen dagegen erst hier erfolgen,
			weil die Elemente erst jetzt sicher angesprochen werden können
			aios_enableCollapsingSidebar();*/

        // in jedem Fall das Hidden-Attribut zurücksetzen
        document.getElementById('sidebar-box').setAttribute('hidden', false);

        // wenn die Sidebar beim Start nicht geöffnet sein soll
        // neues bzw. weiteres Fenster
        if(window.opener) {
            fx_sidebarBox.setAttribute('collapsed', window.opener.document.getElementById('sidebar-box').getAttribute('collapsed'));
            aios_toolbar.setAttribute('hidden', window.opener.document.getElementById('aios-toolbar').getAttribute('hidden'));
        }
        // Browserstart
        else {
            //alert(aios_getBoolean('main-window', 'aiosOpen'));
            if(!aios_getBoolean('main-window', 'aiosOpen')) {
                fx_sidebarBox.setAttribute('collapsed', true);
                fx_sidebarSplitter.setAttribute('hidden', true);
            }
        }

        // sonst ist nach Deaktivieren/Aktivieren die Sidebar sichtbar aber leer
        lp = document.getElementById('sidebar-box').getAttribute("aiosLastPanel");
        if(aios_getBoolean(document.getElementById('main-window'), 'aiosOpen') && lp != "") {
            toggleSidebar(lp, true);
            document.getElementById('sidebar-splitter').hidden = false;
            document.getElementById('sidebar-splitter').setAttribute('state', 'open');
        }
    }

    // wenn es keine zuletzt geöffnete Sidebar gibt oder diese nicht mehr existiert, dann nimm die Bookmarks
    lp = fx_sidebarBox.getAttribute("aiosLastPanel");
    if(!lp || (lp && !document.getElementById(lp))) {
        fx_sidebarBox.setAttribute("aiosLastPanel", "viewBookmarksSidebar");
        document.persist(fx_sidebarBox.id, "aiosLastPanel");
    }

    // Sidebar, Toolbar u. Switch beim Start gem. Einstellungen
    try {
        var sidebarInit = aios_gPrefBranch.getCharPref('gen.init');
        var toolbarInit = aios_gPrefBranch.getIntPref('gen.toolbar.init');
        var switchInit = aios_gPrefBranch.getIntPref('gen.switch.init');

        // Sidebar beim Start öffnen
        if(sidebarInit == "open") toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);

        // Sidebar beim Start schließen
        if(sidebarInit == "close" && !aios_isSidebarHidden()) {
            toggleSidebar();
            if(aios_collapseSidebar && aios_allowCollapseSidebar())
                document.getElementById('sidebar-box').setAttribute('collapsed', true);
        }

        // bestimmte Sidebar beim Start öffnen
        if(sidebarInit != "rem" && sidebarInit != "open" && sidebarInit != "close") {
            if(document.getElementById(sidebarInit)) toggleSidebar(sidebarInit, true);
        }

        if(toolbarInit != 2) aios_toolbar.setAttribute('hidden', !toolbarInit);
        if(switchInit != 2) aios_toggleBox.setAttribute('hidden', !switchInit);
    }
    catch(e) { }

    // bei Doppelklick die Standardgrösse der Sidebar einstellen
    var fx_sidebarheader = document.getElementsByTagName('sidebarheader')[0];
    fx_sidebarheader.addEventListener("dblclick", function(e) {
        aios_setSidebarWidth(e);
    }, false);

    // Sidebars-Menü überwachen - nötig für den Fall, dass ein erster Aufruf durch das View-Menü erfolgt
    //fx_sidebarMenu.addEventListener('popupshowing', aios_modSidebarMenu, false);

    // Sidebar-Ladezustand überwachen
    /*document.getElementById('sidebar').addProgressListener(aiosSBListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_DOCUMENT);*/

    // BrowserFullScreen erweitern (Verhalten der Sidebar, Sidebar-Switch, usw.)
    var fx_BrowserFullScreen = BrowserFullScreen;
    BrowserFullScreen = function() {
        //if(!window.fullScreen) fx_maximizedWindow = fx_mainWindow.getAttribute('sizemode') == "maximized";
        fx_BrowserFullScreen();
        aios_BrowserFullScreen();
    };

    // onEnterPrintPreview erweitern (AiOS-Elemente unsichtbar machen)
    var fx_onEnterPrintPreview = onEnterPrintPreview;
    onEnterPrintPreview = function() {
        if(aios_gElem('aios-toggle-toolbox')) aios_gElem('aios-toggle-toolbox').setAttribute('style', 'display:none;');
        if(aios_gElem('aios-toolbox-left')) aios_gElem('aios-toolbox-left').setAttribute('style', 'display:none;');
        if(aios_gElem('aios-toolbox-right')) aios_gElem('aios-toolbox-right').setAttribute('style', 'display:none;');
        if(aios_gElem('sidebar-box')) aios_gElem('sidebar-box').setAttribute('style', 'display:none;');
        if(aios_gElem('sidebar-splitter')) aios_gElem('sidebar-splitter').setAttribute('style', 'display:none;');

        fx_onEnterPrintPreview();
    };

    // onExitPrintPreview erweitern (AiOS-Elemente sichtbar machen)
    var fx_onExitPrintPreview = onExitPrintPreview;
    onExitPrintPreview = function() {
        if(aios_gElem('aios-toggle-toolbox')) aios_gElem('aios-toggle-toolbox').setAttribute('style', '');
        if(aios_gElem('aios-toolbox-left')) aios_gElem('aios-toolbox-left').setAttribute('style', '');
        if(aios_gElem('aios-toolbox-right')) aios_gElem('aios-toolbox-right').setAttribute('style', '');
        if(aios_gElem('sidebar-box')) aios_gElem('sidebar-box').setAttribute('style', '');
        if(aios_gElem('sidebar-splitter')) aios_gElem('sidebar-splitter').setAttribute('style', '');

        fx_onExitPrintPreview();
    };


    var new_cmd;
    var new_toggleAffectedChrome = toggleAffectedChrome.toString();

    new_toggleAffectedChrome = new_toggleAffectedChrome.replace(/document\.getElementById\(\"sidebar\"\)\.setAttribute\(\"src\"\, \"about\:blank\"\)\;/g, "");
    new_toggleAffectedChrome = new_toggleAffectedChrome.replace(/if \(gChromeState.sidebarOpen\)/g, "");
    new_toggleAffectedChrome = new_toggleAffectedChrome.replace(/toggleSidebar\(gSidebarCommand\)\;/g, "");

    eval('toggleAffectedChrome = ' + new_toggleAffectedChrome + ';');



    // Anpassungen für diverse andere Erweiterungen
    aios_improveCompatibility();

    // Drag&Drop-Funktion für den Sidebar-Umschalter deaktivieren?
    try {
        var switchDrag = aios_gPrefBranch.getBoolPref("gen.switch.drag");
        var switchDelay = aios_gPrefBranch.getIntPref("gen.switch.delay");

        if(!switchDrag) elem_switch.removeAttribute('ondragenter');
    }
    catch(e) { }

    // Changelog anzeigen?
    try {
        var changelog = aios_gPrefBranch.getCharPref('changelog');
    }
    catch(e) { }

    // mit einer manuell gesetzten 0 lässt sich das abschalten
    // aiosVersion ist die aktuelle Version
    if(parseFloat(changelog) != 0 && fx_sidebarBox) {
        var aiosVersion = fx_sidebarBox.getAttribute('aiosVersion');
        if(aiosVersion && (aiosVersion != changelog)) {

            var aiosUpdated = (changelog != "") ? true : false;

            try {
                aios_gPrefBranch.setCharPref('changelog', aiosVersion);
                var changelog_new = aios_gPrefBranch.getCharPref('changelog');
            }
            catch(e) { }

            // wenn das speichern der aktuellen Version geklappt hat
            if(changelog_new === aiosVersion && gBrowser) {
                var hp = "http://www.exxile.de/aios_installed.htm?v=" + aiosVersion;
                if(aiosUpdated) hp = "http://www.exxile.de/aios_updated.htm?v=" + aiosVersion;

                window.setTimeout("gBrowser.loadTabs(new Array('"+hp+"'), false);", 500);
            }
        }
    }

    // vertikale Buttons?
    try {
        var vButtons = aios_gPrefBranch.getBoolPref("vbuttons");

        fx_mainWindow.setAttribute('aiosVButtons', 'true');
        if(!vButtons) fx_mainWindow.setAttribute('aiosVButtons', 'false');
        document.persist(fx_mainWindow.id, 'aiosVButtons');
    }
    catch(e) { }

    initialised = true;
}


/*
	modifiziert alle Sidebar-Tastenkombinationen, damit das
	Verhalten von Sidebar, Toolbar und Switch immer mit den Einstellungen übereinstimmt
		=> Aufruf durch aios_initSidebar() und aios_savePrefs() in prefs.js
*/
function aios_modKeys() {
    // soll die Toolbar angezeigt werden?
    var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');

    // soll der Switch angezeigt werden?
    var showSwitch = aios_getBoolean(aios_toggleSwitchItem, 'checked');

    // welche Elemente sollen auf eine Tastenkombination reagieren?
    var mode = aios_gPrefBranch.getIntPref('cmode.key');

    var aiosAllKeys = document.getElementsByTagName('key');
    for(var i = 0; i < aiosAllKeys.length; i++) {
        if(aiosAllKeys[i].getAttribute('command')) {

            var elemID = aiosAllKeys[i].getAttribute('command');

            // alle Sidebar-Kürzel mit command
            if(document.getElementById(elemID) && document.getElementById(elemID).getAttribute('group') == "sidebar") {
                var tmp_oncommand = document.getElementById(elemID).getAttribute('oncommand');

                // Leerzeichen entfernen und falls nötig ein ";" anhängen
                var oncommand = tmp_oncommand.replace(/ /, "");
                if(oncommand.substr(oncommand.length - 1, 1) != ";") oncommand = oncommand + ";";

                if(showToolbar && (mode == 2 || mode == 3 || mode == 4)) {
                    //oncommand = oncommand + " onViewToolbarCommand(eval(aios_isSidebarHidden()));";
                    oncommand = oncommand + " aios_toggleToolbar(eval(aios_isSidebarHidden()));";
                }

                if(showSwitch && mode == 3)
                    oncommand = oncommand + " eval(aios_toggleBox.hidden = aios_isSidebarHidden());";

                aiosAllKeys[i].setAttribute('oncommand', oncommand);
            }
        }
    }
}


/*
	stellt bei Doppelklick auf den Sidebarheader die Standardgröße der Sidebar wieder her
		=> Aufruf durch EventListener auf dem Header, gesetzt in aios_initSidebar()
*/
function aios_setSidebarWidth(event) {
    aios_getObjects();

    var mode = "def";
    if(event) {
        if(event.shiftKey) mode = "min";
        if(event.ctrlKey || event.metaKey) mode = "max";    // metaKey = Mac
    }

    try {
        var sWidthVal = aios_gPrefBranch.getIntPref('gen.width.' + mode + 'Val');
        var sWidthUnit = aios_gPrefBranch.getCharPref('gen.width.' + mode + 'Unit');

        if(sWidthUnit == "%") {
            var browserWidth = aios_getBrowserWidth();
            var compWidth = browserWidth[3];

            sWidthVal = parseInt(Math.round((compWidth * sWidthVal) / 100));
        }

        // Sidebargöße einstellen
        fx_sidebarBox.setAttribute('width', sWidthVal);
    }
    catch(e) { }
}


/*
stellt die Anzeige der Sidebar ein
		=> Aufruf durch aios_initSidebar() und aios_savePrefs() in prefs.js
		=> 1 = links, 2 = rechts
*/
function aios_setSidebarOrient() {
    aios_getObjects();

    try {
        // Sidebar-Ausrichtung
        var sidebarOrient = aios_gPrefBranch.getIntPref('gen.orient');
        fx_mainWindow.setAttribute('aiosOrient', 'left');
        if(sidebarOrient == 2) fx_mainWindow.setAttribute('aiosOrient', 'right');
        //document.persist(fx_mainWindow.id, 'aiosOrient');

        // Links-Rechts <=> Rechts-Links
        var cStyleWindow = document.defaultView.getComputedStyle(fx_mainWindow, '');
        fx_mainWindow.setAttribute('aiosMode', 'ltr');
        if(cStyleWindow.direction == "rtl") fx_mainWindow.setAttribute('aiosMode', 'rtl');
        //document.persist(fx_mainWindow.id, 'aiosMode');

        // Fix fuer MileWideBack
        if(document.getElementById('back-strip') && sidebarOrient == 2) {
            var mwb = document.getElementById('back-strip');
            var mwbParent = document.getElementById('back-strip').parentNode;
            mwbParent.removeChild(mwb);
            mwbParent.appendChild(mwb);
        }
    }
    catch(e) { }

    aios_setToolbarPos();
}


/*
	Sidebar-Status auf Veraenderungen ueberwachen
		=> Aufruf durch observes-Elemente (hidden und collapsed) in 'sidebar-box'
*/
function aios_observeSidebar(mode) {
    aios_getObjects();

    // für den Fall, dass vor dem Öffnen die Toolbar ausgeblendet wurde (z.B. durch Switch im Opera-Modus)
    var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');

    //if(showToolbar && !aios_isSidebarHidden()) onViewToolbarCommand(false);
    if(showToolbar && !aios_isSidebarHidden()) aios_toggleToolbar(false);

    // für den Fall, dass vor dem Öffnen der Switch ausgeblendet wurde (z.B. durch Startup-Verhalten)
    var showSwitch = aios_getBoolean(aios_toggleSwitchItem, 'checked');
    if(showSwitch && !aios_isSidebarHidden()) aios_toggleBox.setAttribute('hidden', false);

    // Grippy-Status (CSS achtet auf Attribut 'aios')
    fx_mainWindow.setAttribute('aiosOpen', !fx_sidebarBox.hidden && !fx_sidebarBox.collapsed);
    document.persist(fx_mainWindow.id, 'aiosOpen');

    // Toggle-Button-Status (Button achtet auf Attribut 'checked')
    fx_sidebarBox.setAttribute('checked', !fx_sidebarBox.hidden && !fx_sidebarBox.collapsed);

    // für den Fall, dass vor dem Öffnen der Grippy benutzt wurde...
    if(mode == "hidden") {
        fx_sidebarBox.collapsed = false;
        fx_sidebarSplitter.hidden = false;
        fx_sidebarSplitter.setAttribute('state', 'open');
    }

//alert(fx_sidebarBox.getAttribute('sidebarcommand'));
//document.persist(fx_sidebarBox.id, "sidebarcommand");
}


/*
	Letzte Sidebar merken und als persist speichern
		=> Aufruf durch observes-Element in 'sidebar-box' und aios_modSidebarMenu()
*/
function aios_remLastSidebar() {
    aios_getObjects();

    var actSidebar = false;

    // letzte Sidebar merken und speichern
    var allSidebars = document.getElementsByAttribute('group', 'sidebar');
    for(var i = 0; i < allSidebars.length; i++) {

        // darf kein Element observen (Menüeinträge usw.), aber muss eine Sidebar-URL haben
        if(!allSidebars[i].getAttribute('observes') && allSidebars[i].getAttribute('sidebarurl')) {

            // muss eine ID haben und muss "checked" sein
            if(allSidebars[i].getAttribute('id') && aios_getBoolean(allSidebars[i], 'checked')) {

                // command in der "persist"-var "aiosLastPanel" speichern und zurückgeben
                fx_sidebarBox.setAttribute("aiosLastPanel", allSidebars[i].id);
                document.persist(fx_sidebarBox.id, "aiosLastPanel");
                actSidebar = allSidebars[i].id;

            //fx_sidebarBox.setAttribute("sidebarcommand", allSidebars[i].id);
            //document.persist(fx_sidebarBox.id, "sidebarcommand");

            //fx_sidebarBox.setAttribute('src', fx_sidebar.getAttribute('src'));
            //fx_sidebar.setAttribute('src', fx_sidebarBox.getAttribute('src'));
            }
        }
    }

    return actSidebar;
}


/*
	toggelt die Sidebar im Opera-Verhalten
		=> Aufruf durch aios_toggleSidebar() für Elemente im Opera-Verhalten
*/
function aios_toggleOperaMode(aForcePanel, aForceOpen) {
    aios_getObjects();

    var showToolbar = aios_getBoolean(aios_toggleToolbarItem, 'checked');

    // zu oeffnende Sidebar feststellen
    var openPanel = fx_sidebarBox.getAttribute('aiosLastPanel');						// zuletzt geöffnete Sidebar
    if(openPanel == "") openPanel = "viewBookmarksSidebar";								// Lesezeichen wenn keine Sidebar geöffnet war
    if(aForcePanel) openPanel = aForcePanel;											// bestimmte Sidebar gewünscht (bei jedem oeffnen)

    // vertikaler Toolbar-Modus
    if(aios_toolbar.orient == "vertical") {

        // wenn die Toolbar sichtbar ist
        if(!aios_getBoolean(aios_toolbar, 'hidden')) {

            // wenn die Sidebar sichtbar ist
            if(!aios_isSidebarHidden() && !aForceOpen) {
                fx_sidebarBox.setAttribute("aiosShouldOpen", true);							// Zustand der Sidebar merken (sichtbar)
                document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
                toggleSidebar();															// Sidebar ausblenden
            }
            else {
                fx_sidebarBox.setAttribute("aiosShouldOpen", false);						// Zustand der Sidebar merken (unsichtbar)
                document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
            }

            //aios_toolbar.setAttribute('hidden', true);
            //if(!aForceOpen) onViewToolbarCommand(true);									// Toolbar ausblenden
            if(!aForceOpen) aios_toggleToolbar(true);										// Toolbar ausblenden
        }
        // wenn die Toolbar nicht sichtbar ist
        else {
            if(showToolbar)																	// Toolbar anzeigen?
                aios_toggleToolbar(false);												// Toolbar einblenden
            //onViewToolbarCommand(false);												// Toolbar einblenden
            //aios_toolbar.setAttribute('hidden', false);

            // wenn Sidebar angezeigt werden soll (Status vor dem letzten Schließen) oder die Toolbar abgeschaltet wurde
            if(aios_getBoolean(fx_sidebarBox, 'aiosShouldOpen') || !showToolbar) toggleSidebar(openPanel);
        }
    }
    // horizontaler Toolbar-Modus
    else {
        // wenn die Sidebar sichtbar ist
        if(!aios_isSidebarHidden()) {
            fx_sidebarBox.setAttribute("aiosShouldOpen", true);							// Zustand der Sidebar merken (sichtbar)
            document.persist(fx_sidebarBox.id, 'aiosShouldOpen');
            toggleSidebar();															// Sidebar ausblenden
        }
        else {
            if(lastPanel == "") toggleSidebar(openPanel);

        //if(showToolbar) aios_toolbar.setAttribute('hidden', false);
        }
    }

}


/*
	klont das Firefox-Sidebar-Menü für die Sidebars-Buttons
		=> Aufruf durch Menübutton-Events 'onpopupshowing' aufgerufen
*/
function aios_getSidebarMenu(aPopup) {

    aios_getObjects();

    // Menü modifizieren (aktiven Menüpunkt deaktivieren, Ez Sidebar-Fix u.a.)
    aios_modSidebarMenu();

    /*var aios_sidebarMenu = fx_sidebarMenu.cloneNode(true);
	aios_sidebarMenu.setAttribute('onpopupshowing', 'aios_getSidebarMenu(this);');
	aPopup.parentNode.replaceChild(aios_sidebarMenu, aPopup);*/

    while(aPopup.hasChildNodes()) {
        aPopup.removeChild(aPopup.firstChild);
    }

    for(var i = 0; i < fx_sidebarMenu.childNodes.length; i++) {
        aPopup.appendChild(fx_sidebarMenu.childNodes[i].cloneNode(true));
    }
}


/*
	schließt die Sidebar, wenn die Maus den Content-Bereich überfährt
		=> Aufruf durch mouseover des 'appcontent' und des Sidebar-Switches (mit Übergabe von mode)

		=> aios_initSidebar() fügt dem Object "sidebar-box" einen mouseover-Event hinzu,...
		=> dieser mouseover-Event fügt dem "appcontent" einen mouseover-Event hinzu,...
		=> der diese Funktion aufruft
*/
var aios_autoTimeout;
function aios_autoShowHide(mode) {
    //try {
    var autobutton = aios_getBoolean('aios-enableAutohide', 'checked');

    var autoshow = aios_gPrefBranch.getBoolPref('gen.switch.autoshow');
    var onlymax = aios_gPrefBranch.getBoolPref('gen.switch.onlymax');
    var delay = aios_gPrefBranch.getIntPref('gen.switch.delay');
    var hidemethod = aios_gPrefBranch.getIntPref('gen.switch.hidemethod');

    // Feature nicht aktiviert, Feature soll nur bei max. Fenster greifen, Fenster hat nicht den Focus
    if(!autoshow || !autobutton || (onlymax && !aios_isWinMax()) || !aiosFocus) return false;

    /*
			Auslösung durch den Umschalter
		*/
    if(mode == "switch") {
        // wenn Sidebar sichtbar und nicht ausgeblendet werden soll => ignorieren
        if(!aios_isSidebarHidden() && hidemethod == 1) return false;

        // nach bestimmter Zeit ein-/ausblenden
        aios_autoTimeout = window.setTimeout("aios_toggleSidebar('switch')", delay);

        // timeout wieder löschen, wenn die Maus zu kurz auf dem Umschalter war oder geklickt wurde
        elem_switch.addEventListener("mouseout", function(){
            window.clearTimeout(aios_autoTimeout);
        }, true);
        elem_switch.addEventListener("click", function(){
            window.clearTimeout(aios_autoTimeout);
        }, true);

        return true;
    }
    /*
			Auslösung durch den Contentbereich
		*/
    else {

        // wenn Sidebar sichtbar und ausgeblendet werden soll
        // mode.originalTarget.parentNode.id != "" => behebt Kompatibilitätsproblem mit TabSidebar (Sidebar wird bei Rollover des SidebarTabs ausgeblendet)
        if(!aios_isSidebarHidden() && hidemethod == 1 && mode.originalTarget.parentNode.id != "") {

            // Event auf "appcontent" wieder löschen, weil sonst die Sidebar wieder eingeblendet würde
            // => mouseover der Sidebar (in aios_initSidebar()) fügt dem "appcontent" dieses Feature wieder hinzu
            document.getElementById('appcontent').removeEventListener("mouseover", aios_autoShowHide, true);

            // nach bestimmter Zeit ausblenden
            aios_autoTimeout = window.setTimeout("aios_toggleSidebar('switch')", delay);

            // timeout wieder löschen, wenn die Maus zurück in die Sidebar kommt
            fx_sidebarBox.addEventListener("mouseover", function(){
                window.clearTimeout(aios_autoTimeout);
            }, true);
        }
    }
    //}
    //catch(e) { }

    return true;
}


/*
	aktiviert/deaktiviert die Sidebar/Toolbar/Switch je nach Element und Einstellungen
		=> Aufruf durch Toggle-Button, Switch, Shortcut, Open/Close-Menuitems, Sidebar-Close-Button
			=> mode 1: nur die Sidebar öffnen/schließen
			=> mode 2: Sidebar und Toolbar öffnen/schließen
			=> mode 3: Sidebar, Toolbar und Togglebar öffnen/schließen
			=> mode 4: Opera-Verhalten
*/
function aios_toggleSidebar(aMode, aForceOpen) {
    aios_getObjects();
    //aForceOpen = false;			// erlaubt das automatische ein-/ausblenden während Drag auf Sidebar Switch

    var prefstring = "key";
    if(aMode == elem_switch || aMode == "switch") prefstring = "switch";
    if(aMode == elem_tbb || aMode == "tbb") prefstring = "tbb";
    if(aMode == elem_close || aMode == elem_close2 || aMode == "close") prefstring = "close";

    try {
        var mode = aios_gPrefBranch.getIntPref('cmode.' + prefstring);
        var toolBox_enabled = aios_getBoolean('aios-viewToolbar', 'checked');
        var toggleBox_enabled = aios_getBoolean(aios_toggleSwitchItem, 'checked');

        // direkte Übergabe per JavaScript z.B. per "Custom Buttons"
        if(aMode === 1) mode = 1;
        if(aMode === 2) mode = 2;
        if(aMode === 3) mode = 3;
        if(aMode === 4) mode = 4;


        // bestimmtes Panel laden?
        var forcePanel;
        var openPanel = aios_gPrefBranch.getCharPref("gen.open.init");
        if(openPanel != "rem" && (prefstring == "key" || prefstring == "switch" || prefstring == "tbb")) forcePanel = openPanel;
        else forcePanel = false;

        if(mode == 4) {
            aios_toggleOperaMode(forcePanel, aForceOpen);
        }
        else {
            // wenn Sidebar Collpasing aktiviert ist...
            // ein bestimmtes Panel grundsätzlich geöffnet werden soll...
            // es aber noch nicht geöffnet ist...
            // die Sidebar aber noch geöffnet ist...
            // dann soll das Panel zwar geladen, die Sidebar aber dennoch geschlossen werden => reiner Performance-Zweck
            if(aios_collapsingSidebar && forcePanel && fx_sidebarBox.getAttribute('aiosLastPanel') != forcePanel && !aios_isSidebarHidden()) var closeNow = true;

            var tmpcmd = (forcePanel) ? forcePanel : fx_sidebarBox.getAttribute('aiosLastPanel');
            toggleSidebar(tmpcmd, aForceOpen);

            // Sidebar schließen, wenn die obigen Bedingungen erfüllt sind
            if(closeNow) toggleSidebar(tmpcmd, aForceOpen);


            if((mode == 2 || mode == 3) && toolBox_enabled) {
                //aios_toolbar.setAttribute('hidden', aios_isSidebarHidden());
                //onViewToolbarCommand(aios_isSidebarHidden());
                aios_toggleToolbar(aios_isSidebarHidden());
            }

            if(mode == 3 && toggleBox_enabled)
                aios_toggleBox.setAttribute('hidden', aios_isSidebarHidden());
        }
    }
    catch(e) { }

    return true;
}


/*
	Sidebar-Toggle per collapsed
		=> Aufruf durch den Grippy selbst bei onClick()
*/
function aios_useGrippy() {
    fx_sidebarBox.collapsed = !fx_sidebarBox.collapsed;
}


/*
	aktiviert/deaktiviert den schmalen Sidebar-Umschalter
		=> Aufruf durch Event-Listener "onresize" in aios.xul, observer (sizemode) in tbx.xul,
			 aios_BrowserFullScreen() und aios_savePrefs() in prefs.js
*/
function aios_checkThinSwitch() {
    if(!initialised) return;

    aios_getObjects();

    var thin_switch, thinmax_switch, switch_width, switch_twidth, athin_switch;

    try {
        thin_switch = aios_gPrefBranch.getBoolPref('gen.switch.thin');
        thinmax_switch = aios_gPrefBranch.getBoolPref('gen.switch.thinmax');

        switch_width = aios_gPrefBranch.getIntPref('gen.switch.width');
        switch_twidth = aios_gPrefBranch.getIntPref('gen.switch.twidth');

        // soll er schmal sein?
        var thin = thin_switch;
        if(thin_switch && thinmax_switch && !aios_isWinMax()) thin = false;

        var width_val = (thin) ? switch_twidth : switch_width;
        var barStyle = "min-width: " + width_val + "px; max-width: " + width_val + "px;";

        if(width_val < 4) elem_switch.setAttribute('style', 'background-image: none;');
        else elem_switch.setAttribute('style', '');

        if(width_val < 2) barStyle += " border: none;";
        aios_toggleBar.setAttribute('style', barStyle);
    }
    catch(e) { }
}


/*
  Steuerung der Mausaktionen des Sidebar-Umschalters
    => Aufruf durch onClick() des Umschalters
*/
function aios_controlSwitch(ev, which) {
    // Linksklick => metaKey = Mac
    if(ev.button == 0 && (!ev.shiftKey && !ev.ctrlKey && !ev.metaKey)) {
        aios_toggleSidebar(which);
    }

    // Mittelklick / Ctrl+Linksklick => metaKey = Mac
    if(ev.button == 1 || (ev.button == 0 && ev.ctrlKey) || (ev.button == 0 && ev.metaKey)) {
        aios_toggleElement('aios-viewToolbar');
        aios_toggleToolbar('aios-viewToolbar');
    }

    // Rechtsklick / Shift+Linksklick
    if(ev.button == 2 || (ev.button == 0 && ev.shiftKey)) {
        if(aios_isSidebarHidden()) toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);
        else toggleSidebar();
    }
}


/*
	Erweitert die FF-Funktion BrowserFullScreen() zur Steuerung der AIOS-Elemente
		=> Aufruf durch aios_initSidebar()
*/
function aios_BrowserFullScreen() {
    aios_getObjects();

    try {
        // Soll-Zustände
        var close_switch = aios_gPrefBranch.getBoolPref('fs.switch');
        var close_toolbar = aios_gPrefBranch.getBoolPref('fs.toolbar');
        var close_sidebar = aios_gPrefBranch.getBoolPref('fs.sidebar');
        var enable_restore = aios_gPrefBranch.getBoolPref('fs.restore');

        // Ist-Zustände
        var rem_switchHidden = aios_getBoolean(aios_toggleBox, 'hidden');
        var rem_toolbarHidden = aios_getBoolean(aios_toolbar, 'hidden');
        var rem_sidebarHidden = aios_isSidebarHidden();
    }
    catch(e) {
        return false;
    }

    // Fullscreen an
    // 	=> Elemente ausblenden
    if(window.fullScreen) {

        // Ist-Zustände speichern
        aios_toggleBox.setAttribute('fsSwitch', rem_switchHidden);
        aios_toggleBox.setAttribute('fsToolbar', rem_toolbarHidden);
        aios_toggleBox.setAttribute('fsToolbarMode', aios_toolbar.getAttribute("mode"));
        aios_toggleBox.setAttribute('fsToolbarIconsize', aios_toolbar.getAttribute("iconsize"));
        aios_toggleBox.setAttribute('fsSidebar', rem_sidebarHidden);

        // Soll-Zustände herstellen (SidebarSwitch und Toolbar werden standardmäßig ausgeblendet)
        if(close_sidebar && !rem_sidebarHidden) toggleSidebar();

        aios_toggleBar.setAttribute("moz-collapsed", false);
        if(close_switch && !rem_switchHidden) aios_toggleBox.hidden = true;

        document.getElementById('aios-sbhtoolbar').setAttribute("moz-collapsed", false);

        aios_toolbar.setAttribute("moz-collapsed", false);
        //if(close_toolbar && !rem_toolbarHidden) onViewToolbarCommand(true);
        if(close_toolbar && !rem_toolbarHidden) aios_toggleToolbar(true);

        // Toolbar für Fullscreen einstellen (nur ohne die Erweiterung Autohide)
        if(typeof autoHIDE != "object") {
            aios_toolbar.setAttribute("mode", "icons");
            aios_toolbar.setAttribute("iconsize", "small");
        }
    }
    // Fullscreen aus
    // 	=> Elemente einblenden
    else {
        // Toolbareinstellungen wiederherstellen (nur ohne die Erweiterung Autohide)
        if(typeof autoHIDE != "object") {
            aios_toolbar.setAttribute("mode", aios_toggleBox.getAttribute('fsToolbarMode'));
            aios_toolbar.setAttribute("iconsize", aios_toggleBox.getAttribute('fsToolbarIconsize'));
        }

        if(enable_restore) {
            if(!aios_getBoolean(aios_toggleBox, 'fsSidebar')) toggleSidebar(fx_sidebarBox.getAttribute('aiosLastPanel'), true);
            else if(!aios_isSidebarHidden()) toggleSidebar();

            //onViewToolbarCommand(aios_getBoolean(aios_toggleBox, 'fsToolbar'));
            aios_toggleToolbar(aios_getBoolean(aios_toggleBox, 'fsToolbar'));
            aios_toggleBox.hidden = aios_getBoolean(aios_toggleBox, 'fsSwitch');
        }
    }

    // aktiviert/deaktiviert den schmalen Sidebar-Umschalter
    aios_checkThinSwitch();

    aios_adjustToolboxWidth(false);

    return true;
}


/*
  prüft, ob die Funktion "Sidebar Collapse" aus Kompatibilitätsgründen benutzt werden darf
    => Aufruf durch aios_initSidebar()
*/
function aios_allowCollapseSidebar() {
    if(document.getElementById('ezsidebarBroadcasterSet')) return false;	// EZ Sidebar
    if(document.getElementById('moztweaksBundle')) return false;			// Optimoz Tweaks
    if(typeof newToggleSidebar == "function") return false;					// OutSidebar
    return true;
}


/*
	Sidebar nur zusammenklappen statt schließen
		=> Aufruf noch vor aios_initSidebar()
*/
function aios_enableCollapsingSidebar() {
    // Ueberwachung des 'hidden'-Attributs verhindern
    //var obs = document.getElementById('aios_observeHidden');
    //if(obs) obs.parentNode.removeChild(obs);

    /*
		Aenderungen der Funktion toggleSidebar()
	*/
    var new_cmd;
    var new_toggleSidebar = toggleSidebar.toString();

    // Sidebar-Command
    // sidebarBox.setAttribute("sidebarcommand", "");
    //new_toggleSidebar = new_toggleSidebar.replace(/sidebarBox.setAttribute\(\"sidebarcommand\", \"\"\);/g, "");

    // Sidebar-Titel
    // sidebarTitle.value = "";
    new_toggleSidebar = new_toggleSidebar.replace(/sidebarTitle.value = \"\";/g, "");

    // Sidebar-Source
    // sidebar.setAttribute("src", "about:blank");
    new_toggleSidebar = new_toggleSidebar.replace(/sidebar.setAttribute\(\"src\", \"about\:blank\"\);/g, "");

    // Sidebar schließen
    // sidebarBox.hidden = true;
    new_cmd = "sidebarBox.removeAttribute('hidden'); sidebarBox.setAttribute('collapsed', true);";
    new_toggleSidebar = new_toggleSidebar.replace(/sidebarBox.hidden = true;/g, new_cmd);

    // Sidebar öffnen
    new_cmd = "sidebarBox.removeAttribute('hidden'); sidebarBox.setAttribute('collapsed', false);";
    new_toggleSidebar = new_toggleSidebar.replace(/sidebarBox.hidden = false;/g, new_cmd);

    eval('toggleSidebar = ' + new_toggleSidebar + ';');


    /*
		Aenderungen der Funktion BrowserStartup()
	*/
    var new_BrowserStartup = BrowserStartup.toString();

    // Sidebar öffnen
    new_cmd = "if (openerSidebarBox && !openerSidebarBox.hidden && !openerSidebarBox.collapsed)";
    new_BrowserStartup = new_BrowserStartup.replace(/if \(openerSidebarBox && !openerSidebarBox.hidden\)/g, new_cmd);

    eval('BrowserStartup = ' + new_BrowserStartup + ';');
}


/*
	Überwacht ob das Fenster den Fokus hat => unterschiedliche Farben für Darwin
		=> Aufruf durch den observer in aios.xul
*/
function aios_notifyActive() {
    if(aios_appOS != "Darwin") return;

    var elem;
    var sb = document.getElementById('sidebar');
    var active = document.getElementById('main-window').getAttribute('active');

    if(sb.contentDocument) {
        if(sb.contentDocument.getElementById('downloadManager')) {
            elem = sb.contentDocument.getElementById('downloadManager');
        }

        if(sb.contentDocument.getElementById('extensionsManager')) {
            elem = sb.contentDocument.getElementById('extensionsManager');
        }

        if(sb.contentDocument.getElementById('JSConsoleWindow')) {
            elem = sb.contentDocument.getElementById('JSConsoleWindow');
        }

        if(sb.contentDocument.getElementById('Console2Window')) {
            elem = sb.contentDocument.getElementById('Console2Window');
        }

        if(sb.contentDocument.getElementById('webpanels-window')) {
            elem = sb.contentDocument.getElementById('webpanels-window');
        }

        if(sb.contentDocument.getElementById('main-window')) {
            elem = sb.contentDocument.getElementById('main-window');
        }

        if(sb.contentDocument.getElementById('viewSource')) {
            elem = sb.contentDocument.getElementById('viewSource');
        }
    }

    if(typeof elem == "object") elem.setAttribute('active', active);
}