
function aios_improveCompatibility() {
	// FF 2.0 <=> FF 3.0
	aios_modGranParadiso();

	// Optimoz-Tweaks-Fix
	aios_optimozTweaksMode(true);
	window.setTimeout("aios_optimozTweaksMode(true)", 300);

	// DOM Inspector-Fix
	aios_checkDOMi();
	window.setTimeout("aios_checkDOMi()", 300);

	// Console2-Fix
	window.setTimeout("aios_modConsole2()", 300);

	// GoogleToolbar-Fix (zur Sicherheit zweimal, 1. verhindert "aufblitzen", 2. stellt Funktion sicher)
	aios_modGoogleTB();
	window.setTimeout("aios_modGoogleTB()", 300);

	aios_modRSSEditor();
	aios_modFlock();
    aios_modSitebar();
    aios_modMinimizeToTray();
    
    // MileWideBack-Fix
    // wird in aios.js => aios_setSidebarOrient() ausgefuehrt
}


/*
	Anpassungen fr MinimizeToTray (sonst ffnet sich der Download-Manager nicht bei Aufruf ber das Trayicon)
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modMinimizeToTray() {
  if(!document.getElementById('extensions.mook.minimizetotray.traypopup')) return false;

  var mmttMenuItems = document.getElementById('extensions.mook.minimizetotray.traypopup').childNodes;
  var itemCmd;
  for(var i = 0; i < mmttMenuItems.length; i++) {
    itemCmd = mmttMenuItems[i].getAttribute('oncommand');
    if(itemCmd.indexOf("toOpenWindowByType('Download:Manager'") >= 0) {
      var newCmd = 'aios_WIN.aiosIsWindow = true; window.setTimeout("aios_WIN.aiosIsWindow=false;", 500);' + itemCmd;
      mmttMenuItems[i].setAttribute('oncommand', newCmd);
    }
  }

  return true;
}


/*
	Anpassungen fr SiteBar (sonst funktioniert der Back-Button und die URL-Bar nicht)
		=> Aufruf durch aios_improveCompatibility()
		
		=> seit 0.7.2 Beta 2 (bzw. Sitebar Client 2.0) nicht mehr ntig, jetzt nderung rckgngig machen
*/
function aios_modSitebar() {
  if(typeof SiteBar_browserOverlay != 'object') return false;
    
  aios_gPref.clearUserPref('sitebar.position.sidebar.list');
  //aios_gPref.setCharPref('sitebar.position.sidebar.list', 'aiosLeft');
  aios_gPref.savePrefFile(null);

  return true;
}


/*
	Anpassungen fr FF 2.0 <=> FF 3.0
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modGranParadiso() {
	if(aios_appVersion.indexOf('3.0') == 0) {
		
		if(document.getElementById('viewPageInfoSidebar')) 
		  document.getElementById('viewPageInfoSidebar').setAttribute('sidebarurl', 'chrome://browser/content/pageinfo/pageInfo.xul');
		
		return true;
		
		var bmButton = document.getElementById('bookmarks-button');
		if(bmButton) {
			if(bmButton.parentNode.tagName == "toolbarpaletteitem")
				bmButton.parentNode.parentNode.removeChild(bmButton.parentNode);
			else bmButton.parentNode.removeChild(bmButton);
		}

		var bmMitem = document.getElementById('bookmarks-mitem');
		if(bmMitem) bmMitem.setAttribute('hidden', true);

		var hiButton = document.getElementById('history-button');
		if(hiButton) {
			if(hiButton.parentNode.tagName == "toolbarpaletteitem")
				hiButton.parentNode.parentNode.removeChild(hiButton.parentNode);
			else hiButton.parentNode.removeChild(hiButton);
		}

		var hiMitem = document.getElementById('history-mitem');
		if(hiMitem) hiMitem.setAttribute('hidden', true);

		var sepMitem = document.getElementById('bookmarks_sep');
		if(sepMitem) sepMitem.setAttribute('hidden', true);
	}

	return true;
}


/*
	DOM Inspector-Anpassungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_checkDOMi() {
	if(aios_WIN.document.getElementById('Tasks:InspectPage')) return false;

	var domiSidebar = document.getElementById('viewDOMInspectorSidebar');
	if(domiSidebar) domiSidebar.parentNode.removeChild(domiSidebar);

	var domiButton = document.getElementById('dominspector-button');
	if(domiButton) {
		if(domiButton.parentNode.tagName == "toolbarpaletteitem")
			domiButton.parentNode.parentNode.removeChild(domiButton.parentNode);
		else domiButton.parentNode.removeChild(domiButton);
	}

	var domiMitem = document.getElementById('dominspector-mitem');
	if(domiMitem) domiMitem.setAttribute('hidden', true);

	return true;
}


/*
	Console2-Anpassungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modConsole2() {
	if(!document.getElementById('viewConsole2Sidebar')) return false;

	// meinen Sidebar-Men-Eintrag der Console2 zuweisen
	document.getElementById('console-mitem').setAttribute('observes', 'viewConsole2Sidebar');

	// meinen Broadcaster lschen > keine Auswahlmglichkeit in den Prefs
	if(document.getElementById('viewConsoleSidebar')) {
		var consoleBroad = document.getElementById('viewConsoleSidebar');
		consoleBroad.parentNode.removeChild(consoleBroad);
	}

	// Console2-Button
	var coButton = document.getElementById('console2-button');
	if(coButton) {
		if(coButton.parentNode.tagName == "toolbarpaletteitem")
			coButton.parentNode.parentNode.removeChild(coButton.parentNode);
		else coButton.parentNode.removeChild(coButton);
	}

	/*
	if(document.getElementById('console2-button')) {
		document.getElementById('console2-button').removeAttribute('oncommand');
		document.getElementById('console2-button').setAttribute('command', 'Tools:Console');
		document.getElementById('console2-button').setAttribute('onclick', 'aios_contextEvent(event, this);');

		// Observer hinzufgen
		var new_obs = document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "observes");
		new_obs.setAttribute('element', 'viewConsole2Sidebar');
		new_obs.setAttribute('attribute', 'checked');
		document.getElementById('console2-button').appendChild(new_obs);
	}
	*/

	return true;
}


/*
	Optimoz-Tweaks-Anapssungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_optimozTweaksMode(mode) {
	if(typeof window.moztweaksPrefObserver != "object") return false;

	aios_getObjects();

	// 	=> bei jedem MouseOver ntig, weil sich die Einstellungen von OptiMoz gendert haben knnten
	if(mode == true) {
		aios_toggleBox.addEventListener("mouseover", aios_optimozTweaksMode, false);
		aiostbx_left_toolbox.addEventListener("mouseover", aios_optimozTweaksMode, false);
	}
	else {
		try {
			var hidemethod = aios_gPref.getIntPref('moztweaks.sidebar.hidemethod');
		}
		catch(e) { }

		// 	=> Event-Listener entfernen und hinzufgen
		if(hidemethod == 0) {
			aios_toggleBox.removeEventListener("mousemove", mtSidebarMouseMoveListener, false);
			aios_toggleBox.addEventListener("mousemove", mtMouseMoveListener, false);
			aios_toggleBox.addEventListener("mousemove", mtPreventHiding, true);

			aiostbx_left_toolbox.removeEventListener("mousemove", mtSidebarMouseMoveListener, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtMouseMoveListener, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtPreventHiding, true);
		}
		else if(hidemethod == 1) {
			aios_toggleBox.removeEventListener("mousemove", mtMouseMoveListener, false);
			aios_toggleBox.removeEventListener("mousemove", mtPreventHiding, false);
			aios_toggleBox.addEventListener("mousemove", mtSidebarMouseMoveListener, false);

			aiostbx_left_toolbox.removeEventListener("mousemove", mtMouseMoveListener, false);
			aiostbx_left_toolbox.removeEventListener("mousemove", mtPreventHiding, false);
			aiostbx_left_toolbox.addEventListener("mousemove", mtSidebarMouseMoveListener, false);
		}
	}

	return true;
}


/*
	Google-Toolbar-Anpassungen
		=> gewnschten Toolbar-Zustand wiederherstellen (wurde gespeichert durch onViewToolbarCommand() in tbx.js)
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modGoogleTB() {

	if(typeof GTB_GoogleToolbar != "function" || !document.getElementById('aios-viewToolbar')) return false;

	var gtbStatus = document.getElementById('aios-viewToolbar').getAttribute('gtbToolbar');
	if(gtbStatus == "") return false;

	document.getElementById('gtbToolbar').collapsed = !aios_getBoolean('aios-viewToolbar', 'gtbToolbar');

	return true;
}


/*
	RSS-Editor-Anpassungen
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modRSSEditor() {
	if(document.getElementById('viewRsseditorSidebar'))
		document.getElementById('viewRsseditorSidebar').setAttribute('autoCheck', false);
}


/*
	Anpassungen fr Flock
		=> Aufruf durch aios_improveCompatibility()
*/
function aios_modFlock() {
	if(aios_appVendor != "Flock") return false;
/*
	if(document.getElementById('viewBookmarksSidebar')) {
		var bmSB = document.getElementById('viewBookmarksSidebar');
		bmSB.parentNode.removeChild(bmSB);

		var bmCM = document.getElementById('View:Bookmarks');
		bmCM.parentNode.removeChild(bmCM);

		var bmMI = document.getElementById('bookmarks-mitem');
		bmMI.parentNode.removeChild(bmMI);
	}
*/
	return true;
}